#!/bin/sh

URL="http://golovan00.yandex.ru/updates"

APPNAME="yasmagent"
BASEDIR="/usr/local/yasmagent"
CONF="/usr/local/etc/yasmagent/agent.conf"
TMP="/tmp/yasmagent"


prepare() {
   if [ ! -d $TMP ]; then
	mkdir $TMP
   fi
}

update_available() {
    if fetch -T 5 -o "$TMP/update.version" "$URL/update.version" 2> /dev/null; then

        local update_version=`cat $TMP/update.version`
        local current_version=`cat $BASEDIR/current.version`

	if [ "t$update_version" != "t$current_version" ] ; then
	    return 0
	fi
    fi

    return 1
}


fetch_update() {
    local update="$1"
    local update_archive="$update.tar.gz"

    if fetch -T 5 -o "$TMP/$update_archive" "$URL/$update_archive" 2>/dev/null; then
	return 0
    fi

    return 1
}



install_update() {

    local update="$1"

    local update_archive="$update.tar.gz"
    local update_path="$TMP/$update_archive"

    if [ -e "$update_path" ] ; then
        tar -xzf "$update_path" -C "$TMP"
    else
        return 1
    fi

    if [ ! -d "$TMP/backup" ]; then
    	mkdir -p "$TMP/backup"
    fi


    # backup previous application

    cp -Rf "$BASEDIR/" "$TMP/backup/"
    rm -Rf "$BASEDIR/*"
 
    mv -f "$CONF" "$TMP/backup"

    # copy new application files
    cp -Rf "$TMP/$update/" "$BASEDIR/"
    cp -Rf "$TMP/$update/agent.conf" "$CONF"

    chmod +x "$BASEDIR/agent.sh"

    # removing tmp dir
    rm -Rf "$TMP"

    # reststarting application
    $BASEDIR/agent.sh restart

    return 0
}


update() {

    local application="$APPNAME"

    prepare

    if update_available ; then

    	local version=`cat $TMP/update.version`
        local update_name="$application-$version"

        if fetch_update $update_name ; then
	    install_update $update_name 
	fi
    fi
}


# run update

update 




