#!/usr/bin/env bash
# Script for backup logs from MapReduce
#
# $Id$


if [[ -z "$1" || "$1" = "-h" ]];then
    echo 'Usage: '$0 [option] \<MR_LOG1\> \<MR_LOG2\> \<MR_LOGn\> '
    [-s <MR_SRV>]      - MapReduce server (default: abies00:8013)
    [-d <BACKUP_DIR>]  - Backup root directory (default: /s[0-3])
    [-m <MASTER_SERVER>] - Master backup server 
    [-F <FLIGHT_FILE>] - Flight file on MASTER_SERVER
    [-S <STATE_FIL>] - State file on MASTER_SERVER
    <MR_LOG1 ... MR_LOG2>  - MapReduce tables'
    exit 2
fi

LOG=/var/log/mr_backup.log

args=`getopt s:d:m:F:S: $*`
set -- $args
for i; do
{    
    case "$i"
    in 
        -s) MR_SRV="$2";
            shift; shift;;
        -d) BASEDIR="$2";
            shift; shift;;
        -m) MASTER=$2;
            shift; shift;;
        -F) FLIGHT=$2;
            shift; shift;;
        -S) STATE=$2;
            shift; shift;;
        --) shift; break;;
    esac
}
done

MR_LOG=($@)

if [ -z "${MR_SRV}" ]; then
	MR_SRV=abies00:8013
fi

if [ -z "${BASEDIR}" ]; then
	BASEDIR=(`df -g | grep /s\[0-9] | awk '{print $4,$6}' | sort -rnk1 | \
          awk '$1>200' | awk '{print $2}'`)
fi

if [ -z "${MASTER}" ]; then
	MASTER=veles02.yandex.ru
fi

if [ -z "${FLIGHT}" ]; then
	FLIGHT=/Berkanavt/mr_backup/mrbackup.flight
fi

if [ -z "${STATE}" ]; then
	STATE=/Berkanavt/mr_backup/mrbackup.state
fi

logging (){
  if [ -z ${LOG} ];   then 
      touch ${LOG}
  fi
  printf "`date '+%Y‐%m‐%d %H:%M:%S'` ${MSG} " >> ${LOG}
}

mr_len=${#MR_LOG[*]}
dir_len=${#BASEDIR[*]}
rand=${RANDOM}
let "rand %= 60"

send_email() {
	_email_to="stunder@yandex-team.ru"
	_host=`hostname`
	signature="-- 
	${_host}
	Сервер отдела поисковых систем департамента эксплуатации компании
	\"Яндекс\"
	Тел.: +7 495 7397000"

	sendmail ${_email_to}<<EOF
From: "${_host}" <${_email_to}>
To: ${_email_to}
Subject: MR-backup on ${_host} failed
Content-Type: text/plain; charset="utf-8"
Mime-Version: 1.0

`
printf "ERROR:\tBackup ${outlog} FAILED!\n\n";
printf "${MSG}\n\n" 
echo "Disk space on ${host}"
echo "Filesystem         Size    Used   Avail Capacity  Mounted on"
df -h | grep /s\[0-9]
`

${signature}
EOF

}

MSG="\n\n"; logging

mr_cat() {
#	/Berkanavt/bin/mr_cat -s ${MR_SRV} ${MR_LOG[$l]} > ${tmpfile} || ret=$?	
	_ret=0
	_sed_log=$(echo ${outlog} | sed 's$\.$\\\\/$')
	MSG=$( { /Berkanavt/bin/mapreduce -server ${MR_SRV} -subkey -lenval -read ${MR_LOG[$l]} >${tmpfile}; }  2>&1) || _ret=$?

	if [ ${_ret} -ge 1 ]; then
        	MSG="ERROR:\tBackup ${outlog} FAILED!\n\n${MSG}"; logging;
        	rm ${tmpfile}; sleep ${rand};
		_retv=0
        	ssh -i /home/backup/.ssh/id_dsa backup@${MASTER} -o ConnectTimeout=20s \
        	"sed -i.bak -e '/'^${_sed_log}'/d' ${FLIGHT} " || _retv=$?
		if [ ${_retv} -ge 1 ]; then
			MSG="ERROR:\tCannot logging state to ${MASTER} \n" 
			logging
		fi
		send_email
    	else
        	/bin/mv ${tmpfile} ${file} 2>/dev/null
        	MSG="INFO:\tBackup ${outlog} completed successfull to ${file} \n"
        	logging; sleep ${rand}
		_retv=0
        	ssh -i /home/backup/.ssh/id_dsa backup@$MASTER -o ConnectTimeout=20s \
        	"sed -i.bak -e '/'^${_sed_log}'/d' ${FLIGHT} && echo ${MR_LOG[$l]} >> ${STATE}" || _retv=$?
		if [ ${_retv} -ge 1 ]; then
			MSG="ERROR:\tCannot logging state to ${MASTER} \n" 
			logging; send_email
		fi
		 
	fi
}

l=0
while ((${l} < ${mr_len}))
do
{
	base=${BASEDIR[$((${l}%${dir_len}))]}
	outlog=$(echo ${MR_LOG[${l}]} | sed -e 's$/$.$g')
	if [[ ${outlog%%.*} == "similar_group" ]]; then
		dir=backup/$(echo ${MR_LOG[${l}]%/*})
	else
		dir=backup/$(echo ${MR_LOG[${l}]%%/*})
	fi
	echo ${dir}
	file=${base}/${dir}/${outlog}
	MSG="INFO:\tBackup ${outlog} started to ${file} \n"; logging
	if ! [ -d ${base}/${dir} ]; then 
		/bin/mkdir -p ${base}/${dir};
	fi

        tmpfile=`mktemp ${file}.tmp.XXXX` 

        if [ ${tmpfile} ]; then
                mr_cat
		echo OK
	else
		MSG="ERROR:\tBackup ${outlog} FAILED!\n"; logging
		MSG="ERROR:\tCannot create temp file for ${file}"
		logging; send_email
        fi

} &    
	let l++
done
wait
