# my.cnf

!include			/place/mysql/${DB}/my_local.cnf

[mysqld]
back_log			= 512
max_connections			= 256
max_connect_errors		= 10000
#wait_timeout			= 30

tmpdir				= /place/mysql/${DB}/tmp

table_open_cache		= 128

max_allowed_packet		= 32M
binlog_cache_size		= 2M

sort_buffer_size		= 4M
join_buffer_size		= 4M

thread_cache_size		= 16

query_cache_size		= 64M
query_cache_limit		= 4M

default-storage-engine		= INNODB

thread_stack			= 192K

tmp_table_size			= 128M
max_heap_table_size		= 128M

expire_logs_days		= 7
log-error			= error.log
log_warnings
slow_query_log
slow_query_log_file		= slow.log
long_query_time			= 2

# *** MyISAM Specific options
key_buffer_size			= 32M
read_buffer_size		= 2M
read_rnd_buffer_size		= 16M
bulk_insert_buffer_size		= 32M
myisam_sort_buffer_size		= 128M
myisam_max_sort_file_size	= 10G
myisam_repair_threads		= 1
myisam_recover			= BACKUP,FORCE

# *** InnoDB Specific options ***
innodb_buffer_pool_size         = 3G
innodb_additional_mem_pool_size = 32M
innodb_data_file_path           = ibdata1:24M:autoextend
innodb_thread_concurrency       = 16
innodb_flush_log_at_trx_commit  = 2
innodb_log_buffer_size          = 8M
innodb_log_file_size            = 1G
innodb_log_files_in_group       = 2
innodb_max_dirty_pages_pct      = 95
innodb_lock_wait_timeout        = 60
innodb_flush_method             = O_DIRECT
innodb_file_per_table

character-set-server		= utf8

[mysqldump]
quick
max_allowed_packet		= 32M

[mysql]
no-auto-rehash

[myisamchk]
key_buffer			= 512M
sort_buffer_size		= 512M
read_buffer			= 8M
write_buffer			= 8M

[mysqld_safe]
#open-files-limit		= 10240


