#!/bin/sh

DB_NAME=${1}
BASE_DATE=`/bin/date +%d-%m-%Y_%H-%M`
DEFAULTS_MYSQL_FILE="/root/.my.cnf"
BACKUP_DIR="/place/mysql_backup"
RSYNC="/usr/bin/rsync"
RSYNC_OPTS="--timeout=300 --contimeout=60 --bwlimit=25000"
DUMP_SERVER="deposito.search.yandex.net"
DUMP_SHARE="kiwiadmin"
DUMP_DIR="hourly"

check_variables() 
{
	if [ -z $DB_NAME ]; then 
		echo "Name of Database not given";
		exit 1;
	fi
	if [ ! -r $DEFAULTS_MYSQL_FILE ]; then
		echo "MySql config file not exists";
		exit 1;
	fi
	if [ ! -d $BACKUP_DIR ]; then
		echo "BackupDIR does not exists";
		exit 1;
	fi
}

mysql_backup()
{
	cd $BACKUP_DIR
	if ! /usr/bin/mysqldump --defaults-file=${DEFAULTS_MYSQL_FILE} -h localhost $DB_NAME > ${DB_NAME}.sql ;then
		/bin/rm ${DB_NAME}.sql;
		exit 1;
	fi
}

create_archive()
{
	cd $BACKUP_DIR
	if ! /bin/tar -czf ${DB_NAME}_${BASE_DATE}.tgz ${DB_NAME}.sql ;then
		/bin/rm ${DB_NAME}_${BASE_DATE}.tgz;
		exit 1;
	fi
	/bin/chmod 600 ${DB_NAME}_${BASE_DATE}.tgz
}

rm_sql_file()
{
	cd $BACKUP_DIR
	/bin/rm ${DB_NAME}.sql
}

check_rsync()
{
	if [ ! -x $RSYNC ]; then
		echo "No rsync installed";
		exit 1;
	fi
}

copy_db_to_deposito()
{
	if ! $RSYNC $RSYNC_OPTS ${DB_NAME}_${BASE_DATE}.tgz rsync://${DUMP_SERVER}/${DUMP_SHARE}/${DB_NAME}/${DUMP_DIR}/ ;then
		echo "Error copying";
		exit 1;
	else
		/bin/rm ${DB_NAME}_${BASE_DATE}.tgz;
	fi
}



check_variables
mysql_backup
create_archive
rm_sql_file
check_rsync
copy_db_to_deposito
