#!/bin/sh
#
# Use please: script.sh <task_version> <task_number> <group_type>
# Example for http://quentao.yandex-team.ru/sandbox/tasks/view?task_id=78866 :
#             script.sh base/stable-16-22 78866 base
#

PATH=/Berkanavt/bin:/Berkanavt/bin/scripts:/Berkanavt/bin/scripts/s42:$PATH
S42_RSH_OPTIONS="-t 250"
s42_timeout="450"

export PATH
export S42_RSH_OPTIONS

###############################################################################
### COMMON PROCEDURES

err()
{
        val=$1
        shift
        echo "ERROR: $*. Exiting.." | tee -a $log_error
        exit $val
}

usage()
{
                echo " "
                echo "  Use please: $0 [-r] [-m value] <task_version> <task_number> <base|int|mmeta|img-mmeta|img-fbase|img-fth>"
                echo "       -b        enable shards identity check, (to avoid db releases) SEPE-4847"
                echo "       -r        do not regenerate HEAD"
                echo "       -m value  set In-Reply-To header in resulting email with this value"
                echo "       -t value  use value as timestamp for new configuration"
                echo "  Example for http://quentao.yandex-team.ru/sandbox/tasks/view?task_id=78866 :"
                echo "              script.sh base/stable-16-22 78866 base"
                echo " "
}

###############################################################################
### LOCAL VARIABLES

[ `id -un` = loadbase ] || err 1 "Only user loadbase can run this script"

replyto=""
regenerate_head=""
check_db_identity_flag="YES" # check by default
while getopts "brm:t:" opt; do
case "$opt" in
  b) check_db_identity_flag="NO" ;;
  r) regenerate_head="NO" ;;
  m) replyto="${OPTARG}" ;;
  t) date_now="${OPTARG}" ;;
  h) usage ;;
  *) usage ;;
esac
done

shift $(($OPTIND - 1))

task_version="$1"
task_number="$2"
suffix="$3"
[ "`echo ${task_number} | grep '[[:digit:]]' | wc -m`" -eq 18 ] && otrs="YES" || otrs="NO"

case $suffix in
base)
        project_type="";
#	project_addrs="<>";

        group_type="base";
        conf="HEAD";

        groupby="--groupby replica --sleep 5";

	s42_timeout="300"
        quantity="1700";
        quantity_prep="2000";
        quantity_act="1700";
;;
base_las)
        project_type="";
#	project_addrs="<>";

        group_type="las_base";
        conf="HEAD";

        export S42_RSH_OPTIONS="-t 450"
        groupby="--groupby replica --sleep 5";

	s42_timeout="450"
        quantity="1700";
        quantity="1600";
        quantity_prep="1600";
        quantity_act="1000";
;;
base_ams)
        project_type="";
#	project_addrs="<>";

        group_type="ams_base";
        conf="HEAD";

        export S42_RSH_OPTIONS="-t 450"
        groupby="--groupby replica --sleep 5";

	s42_timeout="450"
        quantity="1600";
        quantity_prep="1600";
        quantity_act="300";
;;
base_sas)
        project_type="";
#	project_addrs="<>";

        group_type="sas_base";
        conf="HEAD";

        export S42_RSH_OPTIONS="-t 450"
        groupby="--groupby replica --sleep 5";

	s42_timeout="450"
        quantity="1600";
        quantity_prep="400";
        quantity_act="300";
;;
mmeta)
        project_type="";
#	project_addrs="<>";

        group_type="mmeta";
        conf="HEAD";

	s42_timeout="600"
        quantity="100";
        quantity_prep="20";
        quantity_act="5";
;;
mmeta_las)
        project_type="";
#	project_addrs="<>";

        group_type="las_mmeta";
        conf="HEAD";

        quantity="100";
        quantity_prep="100";
        quantity_act="1";
;;
mmeta_ams)
        project_type="";
#	project_addrs="<>";

        group_type="ams_mmeta";
        conf="HEAD";

        quantity="100";
        quantity_prep="100";
        quantity_act="1";
;;
mmeta_sas)
        project_type="";
#	project_addrs="<>";

        group_type="sas_mmeta";
        conf="HEAD";

        quantity="100";
        quantity_prep="10";
        quantity_act="3";
;;
int)
        project_type="";
#	project_addrs="<>";

        group_type="int";
        conf="HEAD";

        quantity="700";
        quantity_prep="1200";
        quantity_act="200";
        check_db_identity_flag="NO"
;;
int_ams)
        project_type="";
#	project_addrs="<>";

        group_type="ams_int";
        conf="HEAD";

        quantity="700";
        quantity_prep="150";
        quantity_act="40";
        check_db_identity_flag="NO"
;;
int_las)
        project_type="";
#	project_addrs="<>";

        group_type="las_int";
        conf="HEAD";

        quantity="700";
        quantity_prep="1200";
        quantity_act="100";
        check_db_identity_flag="NO"
;;
int_sas)
        project_type="";
#	project_addrs="<>";

        group_type="sas_int";
        conf="HEAD";

        quantity="700";
        quantity_prep="700";
        quantity_act="100";
        check_db_identity_flag="NO"
;;
*)
        usage;
        err 1 "task type is unknown."
        exit 1
esac


###############################################################################
### COMMON VARIABLES

: ${date_now:=`date +%s`};
host_now=`hostname`;
user_now=`whoami`;

dir_data="/Berkanavt/binary/";
dir_lock="/Berkanavt/locks";
dir_logs="${dir_data}/logs";
dir_targets="${dir_data}/targets";
dir_scripts="/Berkanavt/bin/scripts";
dir_webscripts="/Berkanavt/webscripts/uploadbase";

log_error="${dir_logs}/${suffix}-${date_now}.err";
log_file="${dir_logs}/${suffix}-${date_now}.log";

target_start="${dir_targets}/${suffix}-start.dst";
target_all="${dir_targets}/all-${suffix}.dst";

target_global_prepare="${dir_targets}/${suffix}-global-prepare.dst";
target_global_activate="${dir_targets}/${suffix}-global-activate.dst";
target_copy="${dir_targets}/${suffix}-copy.dst";
target_check="${dir_targets}/${suffix}-check.dst";
target_add="${dir_targets}/${suffix}-add.dst";
target_prepare="${dir_targets}/${suffix}-prepare.dst";
target_monitor="${dir_targets}/${suffix}-monitor.dst"
target_restart="${dir_targets}/${suffix}-restart.dst";
target_restart2="${dir_targets}/${suffix}-restart2.dst";
target_mail="${dir_targets}/${suffix}-mail.dst"

file_lock="${dir_lock}/bsconfig_configuration_copy.lock"

production_stamp="${project_type}production_${group_type}-${date_now}-${task_number}"
replicas_file=${dir_webscripts}/HEAD/database-switch-replicas.txt

prog_s42="${dir_scripts}/s42/s42";
prog_sky="/usr/local/bin/sky";
prog_bsconfig="/db/bin/bsconfig";
prog_lock="/usr/local/bin/flock"
prog_otrs="/Berkanavt/webscripts/admscripts/scripts/otrs/otrs.py";

#param_s42="itag=${production_tag} --rsh --logfile $log_file";
param_s42="cfg=${production_stamp} --rsh --logfile $log_file --timeout $s42_timeout";
param_bsconfig="--logfile $log_file --batch-mode";
param_bsconfig_master="--logfile $log_file --batch-mode --cms-xmlrpc-yr-url http://cmsearch01e.yandex.ru/xmlrpc/yr --cms-xmlrpc-url http://cmsearch01e.yandex.ru/xmlrpc/bs/ --cms-json-url http://cmsearch01e.yandex.ru/json/bs/";
param_lock="${file_lock}"

SVN_SSH="ssh -q -l search-base-rw -i /Berkanavt/keys/${user_now}/search-base-rw"

export SVN_SSH


###############################################################################
### PROCEDURES

svnup()
{
		cd ${dir_webscripts}/${conf}

		svn up || err 1 "svn up failed"
}
check_depends()
{
	if [ -z "$task_version" -o -z "$task_number" -o -z "$suffix" ]; then
	        usage
		err 1 "not enough arguments"
	fi

	echo $task_version $task_number to $suffix | tee -a "$log_file"
	true
}

check_db_identity()
{
	local _cfg _cfg_list _db_hash _db_hash_specimen
	[ $# -ge 2 ] && _cfg_list=$@ || { echo >&2 "check_db_identity: not enough arguments"; return 1; }
	for _cfg in ${_cfg_list}; do
		_db_hash="`${prog_bsconfig} ${param_bsconfig_master} slookup cfg="${_cfg}"`"
		[ "${?}" -ne 0 ] && { echo >&2 "check_db_identity: FAILED to determine shards for '${_cfg}'"; return 1; }
		_db_hash="`echo "${_db_hash}" | grep -v ^# | awk '{print $1}'`"
		[ "${?}" -ne 0 -o -z "${_db_hash}" ] && { echo >&2 "check_db_identity: FAILED to extract shards for '${_cfg}'"; return 1; }
		_db_hash="`echo "${_db_hash}" | md5`" # FreeBSD only
		[ "${?}" -ne 0 ] && { echo >&2 "check_db_identity: FAILED to calculate hashsum for shards for '${_cfg}'"; return 1; }
		if [ -z "${_db_hash_specimen}" ]; then
			_db_hash_specimen="${_db_hash}"
		else
			[ "${_db_hash_specimen}" = "${_db_hash}" ] || return 1;
		fi
	done
}

added_binary()
{
	cd /Berkanavt/webscripts/uploadbase/${conf}/
	(
        $prog_lock 5
        #if ! $prog_bsconfig $param_bsconfig genconf $conf ${conf}.conf --create-empty-shards --set; then
        if ! $prog_bsconfig $param_bsconfig_master genconf $conf ${conf}.conf --set; then
            err 1 "added_binary failed"
        else
            touch $target_add
        fi

	) 5>$file_lock

	if [ "$?" != "0" ] ; then
		err 1 "added_binary failed"
	else
		touch $target_add
	fi
}

get_diff ()
{
	if ! $prog_bsconfig $param_bsconfig_master configuration_diff --test $conf $production_stamp | grep differ >> $log_file ; then
        echo "WARNING: configurations do not differ" | tee -a $log_file
	fi
	
}

start_copy()
{
	if ! $prog_bsconfig $param_bsconfig_master global_copyconfiguration $conf $production_stamp ; then
		err 1 "global_copyconfiguration failed"
	else
		sleep 5
		touch $target_copy
	fi
}

start_check()
{
	local _active_cfg _cfg _cfg_list _media_subr_lib
	if ! $prog_bsconfig $param_bsconfig_master global_checkconfiguration $production_stamp; then
		err 1 "configuration is bad"
	else
		if [ "$check_db_identity_flag" = "YES" ]; then
			_media_subr_lib="/Berkanavt/webscripts/uploadbase/scripts/media.subr"
			_active_cfg="`verboze=3; bsconfig_bin=$prog_bsconfig; bsconfig_opt_master=$param_bsconfig_master; . "$_media_subr_lib" && get_active_cfg "production_${group_type}" nocache`"
			[ $? -eq 0 ] || err 1 "failed to determine active cfg for prefix 'production_${group_type}'"
			check_db_identity "$_active_cfg" "$production_stamp" || err 1 "configurations have different shard sets"
		fi
		touch $target_check
	fi
}

check_monitor_conf() 
{
	if ! $prog_s42 monitor $param_s42 /${quantity_prep} --check-total-percent 0.85 --check-percent-only #--check-in-shard-percent 0.5
	then
		err 1 "Check monitor failed"
	else
		touch $target_monitor
	fi
}

start_global_restart ()
{
	#sleep 25
	$prog_bsconfig $param_bsconfig_master global_configuration_prepare $production_stamp --set && touch $target_global_prepare
	#sleep 25
	$prog_bsconfig $param_bsconfig_master global_configuration_activate --force $production_stamp --set && touch $target_global_activate
}

start_prepare ()
{
        $prog_s42 $param_s42 /${quantity_prep} "$prog_bsconfig configuration_prepare $production_stamp --now --shards" >> $log_file
        #$prog_sky run -N -C -U -t ${s42_timeout} "sleep \`jot -r 1 0 60\` && $prog_bsconfig configuration_prepare $production_stamp --now --shards 2>/dev/null" C@$production_stamp >> $log_file
        touch $target_prepare

	if [ ! -f $replicas_file ] ; then
	     err 1 "start_copy_settag: File $replicas_file not found"
	fi

}

start_restart ()
{
        $prog_s42 $param_s42 ${groupby} /${quantity_act} "$prog_bsconfig configuration_prepare $production_stamp --now --shards && $prog_bsconfig configuration_activate --noheatup $production_stamp" >> $log_file
        echo "s42 exited with code $?" >> $log_file
        touch $target_restart
}

start_restart_special_order ()
{
	if [ ! -f $replicas_file ] ; then
	     err 1 "start_copy_settag: File $replicas_file not found"
	fi
	#perl -lnae 'BEGIN{ $replica=1; }; system("set -x ; bsconfig --logfile '$log_file' cms setSearchInstanceTag replica-" . $replica++ . "\@'$production_stamp' " .  join(" ", @F));' $replicas_file >> $log_file 2>> $log_file

	
    numreplica=0
    for mark in `sed 's/^.*$/1/' $replicas_file` ; do
        numreplica=$((numreplica+1))
        tagname="replica-$numreplica"
        echo "------ replica " $tagname "------" >> $log_file

            if ! $prog_s42 $param_s42 $param_s42_timeout1 itag=$tagname /${quantity_act} --no-uniq "$prog_bsconfig syncdisable; $prog_bsconfig configuration_prepare $production_stamp --now --shards && $prog_bsconfig configuration_activate --noheatup $production_stamp itag=$tagname"  >> $log_file ; then
                    echo "WARNING: restart incomplete on start_restart_special_order itag $tagname"
            restart_incomplete=YES
        fi
    done

        if [ -n "$restart_incomplete" ] ; then
                echo "WARNING: restart incomplete on start_restart_special_order"
                #touch $target_restart_finish
        #else
                #touch $target_restart_all
        fi
}

start_restart2 ()
{
        $prog_s42 $param_s42 /${quantity} "$prog_bsconfig syncenable; $prog_bsconfig configuration_prepare $production_stamp --now --shards; $prog_bsconfig configuration_activate --noheatup --force $production_stamp" >> $log_file
        #$prog_sky run -N -C -U -t ${s42_timeout} "$prog_bsconfig syncenable; $prog_bsconfig configuration_prepare $production_stamp --now --shards; $prog_bsconfig configuration_activate --noheatup --force $production_stamp" C@$production_stamp >> $log_file
        echo "s42 exited with code $?" >> $log_file
        touch $target_restart2
        touch $target_all
}

start_restart_special_order2 ()
{
	if [ ! -f $replicas_file ] ; then
	     err 1 "start_copy_settag: File $replicas_file not found"
	fi
    numreplica=0
    for mark in `sed 's/^.*$/1/' $replicas_file` ; do
        numreplica=$((numreplica+1))
        tagname="replica-$numreplica"
        echo "------ replica " $tagname "------" >> $log_file

        $prog_s42 $param_s42 $param_s42_timeout1 itag=$tagname /${quantity_act} --no-uniq "/usr/local/bin/perl $prog_bsconfig configuration_prepare $production_stamp --now; /usr/local/bin/perl $prog_bsconfig configuration_activate --noheatup $production_stamp itag=$tagname"  >> $log_file 
    done
}

time_stat ()
{
        start=`stat -f %c $target_add`;
        finish=`stat -f %c $target_all`;
        SS="$(($finish-$start))";
        MM="$(($SS/60))";
}

mail_send ()
{
# report sending...

if [ -n "$replyto" ]; then
  extra_headers="In-Reply-To: ${replyto}"
else
  extra_headers=""
fi


sendmail -t <<EOF
From: "${host_now}" <sereglond@yandex-team.ru>
To: <search-releases@yandex-team.ru>, ${project_addrs}
Reply-to: <sereglond@yandex-team.ru>, <search-releases@yandex-team.ru>, "${project_addrs}"
Subject: [ $task_version ] configuration $production_stamp 
Mime-Version: 1.0
Content-Type: text/plain; charset=utf-8
Content-Transfer-Encoding: 8bit
${extra_headers}

Новый релиз $task_version по таску $task_number выехал в продакшен [ $conf ].
Активная конфигурация кластера теперь называется $production_stamp

Выкладывание программы заняло: ${MM} минут

EOF
touch $target_mail

}

###############################################################################
### MAIN

echo $production_stamp;

check_depends;

svnup;

touch $target_start

if [ -z "${regenerate_head}" ]; then
    if [ ! -f $target_add ] ; then
        added_binary
    fi
else
    [ ! -f $target_add ] && touch $target_add
fi

if [ ! -f $target_copy ] ; then
	#sleep 50
        start_copy
	#sleep 25
fi

if [ ! -f $target_check ] ; then
        #sleep 550
        start_check
fi

if [ ! -f $target_all ] ; then
	#sleep 25

	if [ $group_type = "base" -o $group_type = "las_base" -o $group_type = "ams_base" -o $group_type = "sas_base" ]
	then
		/usr/local/bin/wget -q -O ${replicas_file}.new 'http://cmsearch.yandex.ru/res/gencfg/production/w-generated/switch.steps'
		if ! diff $replicas_file ${replicas_file}.new > /dev/null; then
			cp ${replicas_file}.new $replicas_file
			svn ci -m "new switch.replicas" $replicas_file
		fi
		linecount=`cat $replicas_file | wc -l`
		for i in `jot $linecount 1`; do
			instlimit=5000
			instcount=`head -n $i $replicas_file | tail -n 1 | tr " " "\n" | wc -l`	
		 	if [ $instcount -ge $instlimit ]; then 	
				partinst=`expr $instcount / $instlimit + 1`
				for j in `jot $partinst 1`; do
					$prog_bsconfig $param_bsconfig_master --logfile $log_file cms setSearchInstanceTag replica-$i@$production_stamp `head -n $i $replicas_file | tail -n 1 | tr " " "\n" | head -n $(($j * $instlimit)) | tail -n $instlimit | tr "\n" " "`  >> $log_file 2>> $log_file
				done
			else
				$prog_bsconfig $param_bsconfig_master --logfile $log_file cms setSearchInstanceTag replica-$i@$production_stamp `head -n $i $replicas_file | tail -n 1`  >> $log_file 2>> $log_file
			fi
		done
			#	perl -lnae 'BEGIN{ $replica=1; }; system("set -x ; bsconfig $param_bsconfig_master --logfile '$log_file' cms setSearchInstanceTag replica-" . $replica++ . "\@'$production_stamp' " .  join(" ", @F));' $replicas_file >> $log_file 2>> $log_file



		sleep 300
		start_prepare;
		check_monitor_conf;
		[ "${otrs}" = "YES" ] && $prog_otrs -n ${task_number} -a comment -s ${task_version} -b "Start switching ${production_stamp}." ; start_restart_special_order;
	#	sleep 20;
	#	start_restart_special_order2;
	else
		sleep 300
		start_prepare;
		check_monitor_conf;
		[ "${otrs}" = "YES" ] && $prog_otrs -n ${task_number} -a comment -s ${task_version} -b "Start switching ${production_stamp}." ; start_restart;
	#	sleep 20;
	#	start_restart2;
	fi
	sleep 10;
	start_restart2
	case $otrs in
		YES)
			time_stat && $prog_otrs -n ${task_number} -a close -s ${task_version} -b "Finished switching ${production_stamp}. Switching lasted ${MM} minutes."
		;;
		NO|*)
			time_stat && mail_send
		;;
	esac
	start_global_restart || true
fi


rm $target_start $target_global_prepare $target_global_activate $target_copy $target_check $target_add $target_prepare $target_restart $target_restart2 $target_mail $target_all $target_monitor
