#!/usr/bin/env python

import sys
import os
import optparse
import json
import copy

import mail_sample
import requests


URL_PARAMS = [
    'initiator',
    'cc',
    'replyto',
    'tn',
    'action',
    'ansformat',
    'ansdetail',
    'queueid',
    'articleid',
    'tag',
    'tags',
    'name',
    'id',
    'tid',
    'from',
    'current_page',
    'entries_per_page',
]
DATA_PARAMS = [
    'token',
    'body',
    'subject',
]


def init_body(options):
    if options['body'] or options['no_stdin']:
        return
    action = options['action']
    req_p = requests.KNOWN_REQUESTS[action]._get_required_params()[0]
    req_p.update(requests.KNOWN_REQUESTS[action]._get_required_params()[1])
    if not 'body' in req_p:
        return
    options['body'] = sys.stdin.read()
    if options['body'].isspace():
        options['body'] = None


def add_footer(options):
    if not options.action == 'answer':
        return
    if not options.body:
        return
    options.body = mail_sample.MAIL_SAMPLE % {
        'tn': options.tn,
        'body': options.body,
    }


def init_parser():
    usage = '%prog -a ACTION [options]'
    description = ('Request the bot to manipulate the ticket in OTRS. '
                   'If body parameter is absent reading text from stdin.\n'
                   'Info about possible parameters may be found at '
                   'http://wiki.yandex-team.ru/bot/api/otrs.\n'
                   'Also note that action "gettag" works correct only '
                   'with "-d full -f json" options set.')
    parser = optparse.OptionParser(usage=usage, description=description)
    parser.add_option(
        '-a', '--action', default=None,
        help='Possible actions: %s' % ', '.join(requests.KNOWN_REQUESTS)
    )
    parser.add_option('-q', '--queueid', default=None)
    parser.add_option('-s', '--subject', default=None)
    parser.add_option('-b', '--body', default=None)
    parser.add_option('-n', '--tn', default=None)
    parser.add_option('-c', '--cc', default=None)
    parser.add_option('-r', '--replyto', default=None)
    parser.add_option('-i', '--initiator', default=None)
    parser.add_option('-f', '--ansformat', default=None)
    parser.add_option('-d', '--ansdetail', default=None)
    parser.add_option('-t', '--tag', default=None)
    parser.add_option('--tags', default=None)
    parser.add_option('--articleid', default=None)
    parser.add_option('--name', default=None)
    parser.add_option('--id', default=None)
    parser.add_option('--tid', default=None)
    parser.add_option('--current_page', default=None)
    parser.add_option('--entries_per_page', default=None)
    parser.add_option('--from', default=None)
    no_letter_help = ('Without this option action \'comment\' will act '
                      'like \'answer\' and \'close\' will act like '
                      'two actions: \'answer\' and \'close\' '
                      '(for backward compatibility)')
    parser.add_option('--no-letter', default=False,
                      action='store_true',
                      help=no_letter_help)
    parser.add_option('--no-stdin', default=False, action='store_true',
                      help='Don\'t try to read body from stdin')
    return parser


def load_defaults(options):
    project_dir = os.path.split(__file__)[0]
    defaults_fname = os.path.join(project_dir, 'defaults')
    defaults = json.load(open(defaults_fname))
    for opt in defaults:
        if not options.get(opt):
            options[opt] = defaults.get(opt)
    return options


def split_options(options):
    url_params = {}
    data_params = {}
    for opt in options:
        if opt in URL_PARAMS:
            url_params[opt] = options[opt]
        else:
            data_params[opt] = options[opt]
    return url_params, data_params


def replace_comment_and_answer(options):
    if options.action == 'comment' and not options.no_letter:
        options.action = 'answer'


def parse_result(result, options):
    if options['ansformat'] == 'json':
        json_res = json.loads(result)
        if options['ansdetail'] == 'full':
            status = json_res['status']
        else:
            status = json_res
    else:
        status = result.splitlines()[0]
    print result
    if status == 'FAULT':
        sys.exit(1)


def handle_close(options):
    if options.action == 'close' and not options.no_letter:
        options = [options, copy.copy(options)]
        options[0].action = 'answer'
        options[1].body = ''
        options[1].no_stdin = True
        return options
    return options


def parse_options():
    parser = init_parser()
    options, _ = parser.parse_args()
    if not options.action:
        print 'Action required\n'
        parser.print_help()
        sys.exit(1)
    add_footer(options)
    replace_comment_and_answer(options)
    options = handle_close(options)
    if not isinstance(options, list):
        options = [options]
    return options


def main():
    options_list = parse_options()
    for options in options_list:
        options = load_defaults(options.__dict__)
        init_body(options)
        url_params, data_params = split_options(options)
        result = requests.send_request(url_params, data_params)
        parse_result(result, options)


if __name__ == '__main__':
    main()
