import os
import sys
from urllib import urlencode


def add_params(url, params):
    return '%s?%s' % (url, params)


def get_full_url(url, params_dict):
    '''Convert parameters into string and generate full url'''
    return add_params(url, urlencode(params_dict))


def resolve_conf_path(path):
    if os.path.isabs(path):
        return path

    return os.path.join(os.path.dirname(sys.argv[0]), path)
