#!/bin/sh


golovanconf="conf.txt"
genchart="./gen_chart.py"
genpanel="./gen_chart-panel.py"
golovantags="./golovan.tags"
all_subsources="./subsources.txt"
all_chartsets="./chartsets.txt"
upper_itype="noapache"
upper_tags="prod_web-main_msk_self prestable_web-main_sas_self"
upper_chartset_template="subsource_SNAME_perc"

tags_to_process=$(cat $golovantags | egrep -v "^dehtmld|querysearch|^feedfinder|readis|banflt|_music_" | sort -u)
itypes=$(echo "$tags_to_process" | awk -F '_' '{print $1;}' | sort -u)

# Generating per-itype charts

for current_itype in $itypes; do
    current_chartsets=$(cat $all_chartsets | grep $current_itype | awk '{print $2;}')
    $genchart $golovanconf ${current_itype}:$current_chartsets > panelconfigs/$current_itype.txt
done

# Generating itype charts for upper

subsources_list=$(cat $all_subsources | egrep -v "#"  | awk '{print $1}')
upper_chartsets=""
for subsource_name in $subsources_list; do
    current_chartset=$(echo $upper_chartset_template | perl -pi -e "s/SNAME/$subsource_name/g")
    upper_chartsets="${upper_chartsets},$current_chartset"
done

upper_chartsets=$(echo $upper_chartsets | perl -pi -e "s/^,//g")

$genchart $golovanconf ${upper_itype}:$upper_chartsets > panelconfigs/$upper_itype.txt

# Alerts generation


mainfile=$(cat ./convert_noapache_template.txt)
axes="$(cat ./convert_noapache_axes_template.txt)"
alertspanels="$(cat ./convert_noapache_alertspanels_template.txt)"
notifications="$(cat ./convert_noapache_notifications_template.txt)"


all_subsource_charts=$(egrep -oh 'noapache-subsource_.*._perc' panelconfigs/$upper_itype.txt)
echo "" > ./alertspanels.txt-sub
echo "" > ./notifications.txt-sub

for subsource_chart in $all_subsource_charts; do
    
    alertspanels="$(cat ./convert_noapache_alertspanels_template.txt)"
    notifications="$(cat ./convert_noapache_notifications_template.txt)"

    subsource_name=$(echo $subsource_chart | perl -pi -e "s/noapache-subsource_//g; s/_perc//g")
    ctypes=$(cat $all_subsources | grep "^$subsource_name " | awk '{print $2;}' | perl -pi -e "s/,/ /g")
    subsource_signal="noapache_evlog-not_ok_subsource_${subsource_name}_perc"

    chart_stub="$chart_stub            - $subsource_chart\n"
    axes_signal_stub="$axes_signal_stub            ${subsource_signal}:\n                warning: 1\n                critical: 3\n"

    name_stub="                - \"$subsource_name\""
    signal_stub="                ${subsource_signal}: not ok\n"
    ctype_stub=""
    for ctype in $ctypes; do
        ctype_stub="$ctype_stub               - $ctype\n"
    done
    
    alertspanels=$(echo "$alertspanels" | perl -pi -e "s/NAME_STUB/$name_stub/g; s/SIGNAL_STUB/$signal_stub/g; s/CTYPE_STUB/$ctype_stub/g")
    echo "$alertspanels" >> ./alertspanels.txt-sub
    if ! [ $(echo "$ctypes" | egrep -o "comtrbackup") ]; then
        rus_not_signal_stub="$rus_not_signal_stub                ${subsource_signal}:\n"
    else
        tur_not_signal_stub="$tur_not_signal_stub                ${subsource_signal}:\n"
    fi
done
axes=$(echo "$axes" | perl -pi -e "s/CHART_STUB/$chart_stub/g; s/SIGNAL_STUB/$axes_signal_stub/g")
notifications=$(echo "$notifications" | perl -pi -e "s/RUS_SIGNAL_STUB/$rus_not_signal_stub/g; s/TUR_SIGNAL_STUB/$tur_not_signal_stub/g")
alertspanels=$(cat ./alertspanels.txt-sub)
mainfile=$(echo "$mainfile" | perl -pi -e "s/AXES_STUB/$axes/g; s/ALERTSPANELS_STUB/$alertspanels/g; s/NOTIFICATIONS_STUB/$notifications/g") 
echo "$mainfile" > ./convert_miscs.txt


# Panels generation

# First of all, we need to generate "fake" temporary charts

all_prj=$(echo "$tags_to_process" | awk -F '_' '{print $3;}' | egrep -v "wikifacts"  | perl -pi -e "s/peopless/people/g" | sort -u) # fixup - peopless prj is not a subset of its subsource names

for current_prj in $all_prj; do
    prj_tags=$(echo "$tags_to_process" | grep $current_prj)
    subsources_list=$(cat $all_subsources | egrep -v "#" | awk '{print $1;}' | grep -i $current_prj)
    echo $subsources_list
    upper_chartsets=""
    if [ "$subsources_list" ]; then
        for subsource_name in $subsources_list; do
            current_chartset=$(echo $upper_chartset_template | perl -pi -e "s/SNAME/$subsource_name/g")
            upper_chartsets="${upper_chartsets},$current_chartset"
        done
        upper_chartsets=$(echo $upper_chartsets | perl -pi -e "s/^,//g")
    fi
    
    itypes=$(echo "$prj_tags" | awk -F '_' '{print $1;}' | sort -u)
    if [ $(echo "$itypes" | grep "mmeta") ]; then
        for current_itype in $itypes; do
            current_chartsets=$(cat $all_chartsets | grep $current_itype | awk '{print $2;}')
            if [ $current_itype = "mmeta" ]; then
                if [ $upper_chartsets ]; then
                    echo "$genchart $golovanconf ${current_itype}:$current_chartsets ${upper_itype}:$upper_chartsets"
                    $genchart $golovanconf ${current_itype}:$current_chartsets ${upper_itype}:$upper_chartsets > tmpcharts/${current_prj}_$current_itype.txt
                    current_signals=$(echo "$prj_tags" | grep $current_itype | perl -pi -e "s/^| / ASEARCH:/g")
                    subsource_signals=$(echo "$upper_tags" | perl -pi -e "s/^| / ASEARCH:${upper_itype}_/g")
                    echo "$genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype  $current_signals $subsource_signals"
                    $genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype  $current_signals $subsource_signals > panelconfigs/${current_prj}_$current_itype.txt-panel
                else
                    echo "$genchart $golovanconf ${current_itype}:$current_chartsets"
                    $genchart $golovanconf ${current_itype}:$current_chartsets > tmpcharts/${current_prj}_$current_itype.txt
                    current_signals=$(echo "$prj_tags" | grep $current_itype | perl -pi -e "s/^| / ASEARCH:/g")
                    echo "$genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals"
                    $genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals > panelconfigs/${current_prj}_$current_itype.txt-panel
                fi
            else
                echo "$genchart $golovanconf ${current_itype}:$current_chartsets"
                $genchart $golovanconf ${current_itype}:$current_chartsets > tmpcharts/${current_prj}_$current_itype.txt
                current_signals=$(echo "$prj_tags" | grep $current_itype | perl -pi -e "s/^| / ASEARCH:/g")
                echo "$genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals"
                $genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals > panelconfigs/${current_prj}_$current_itype.txt-panel
            fi
        done
    else
        for current_itype in $itypes; do
            current_chartsets=$(cat $all_chartsets | grep $current_itype | awk '{print $2;}')
            if [ $upper_chartsets ]; then
                echo "$genchart $golovanconf ${current_itype}:$current_chartsets ${upper_itype}:$upper_chartsets"
                $genchart $golovanconf ${current_itype}:$current_chartsets ${upper_itype}:$upper_chartsets > tmpcharts/${current_prj}_$current_itype.txt
                current_signals=$(echo "$prj_tags" | grep $current_itype | perl -pi -e "s/^| / ASEARCH:/g")
                subsource_signals=$(echo "$upper_tags" | perl -pi -e "s/^| / ASEARCH:${upper_itype}_/g")
                echo "$genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals $subsource_signals"
                $genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals $subsource_signals > panelconfigs/${current_prj}_$current_itype.txt-panel
            else
                echo "$genchart $golovanconf ${current_itype}:$current_chartsets"
                $genchart $golovanconf ${current_itype}:$current_chartsets > tmpcharts/${current_prj}_$current_itype.txt
                current_signals=$(echo "$prj_tags" | grep $current_itype | perl -pi -e "s/^| / ASEARCH:/g")
                echo "$genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals"
                $genpanel tmpcharts/${current_prj}_$current_itype.txt ${current_prj}_$current_itype $current_signals > panelconfigs/${current_prj}_$current_itype.txt-panel
            fi
        done
    fi
    
done



exit 0
  

