#!/bin/sh
set -e
set -u
: ${verbose:=false}

vecho()
{
  if [ x${verbose} != xfalse ]; then
    echo $@
  fi
}


rsync_share_path=$1

querysearch_tries='
daily.trie
nw1.trie
nw2.trie
contrast_queries2.trie
reqfreq.trie
daily_words.trie
daily_queries.trie
fast_words.trie
fast_queries.trie
images.trie
ban.trie
images_fast.trie
personal-0.solartrie
staff.trie
scheme-fix.trie
serpfilters.trie
video.trie
personal-1.solartrie
mango_short_urls.trie
blender_clicks.trie
twitter_fast_words.trie
twitter_month_words.trie
fresh_month_queries.trie
video_fast.trie
antiwizard.trie
filters.trie
regnav.trie
ppb_themes.trie
'

banflt_tries='
fastiban.trie
peopleban.trie
docidban.trie
mobileban.trie
short_beak.trie
twitter_users.trie
queryban.trie
fastban_kubr.trie
mango_doorway_queries.trie
mango_histoban_queries.trie
categban.trie
masksban.trie
wmcban.trie
fastban_nevada.trie
wmcban.trie
fastsnips.trie
mabandits.trie
fastban_turkey.trie
'

twiref_tries='
twiref.friends.trie
twiref.referers.trie
twiref.users.trie
'

twisnip_tries='
twisnip.statuses.trie
twisnip.userids.trie
'




if [ -z "${rsync_share_path}" ]; then
  echo "no rsync share specified";
  exit 1;
fi

if [ ! -d "${rsync_share_path}" ]; then
  echo "not a directory: \"${rsync_share_path}\""
  exit 1;
fi

cd "${rsync_share_path}"

for i in $( ls | grep "trie.tag$"); do
  cd "${rsync_share_path}"
  vecho "examining $i"
  tag=$(cat $i)
  trie_name=$( echo $i | sed "s/tag/$tag/" )

  for j in 000 001 002 003 004 005 006 007; do
    cd "${rsync_share_path}/$j" 2>/dev/null || continue
    if [ ! -e ${trie_name} ]; then
      vecho "trie $j/${trie_name} does not exist";
      continue;
    fi

    bare_trie_name=$(echo $i | sed 's/.tag$//')

    if [ ! -e ${trie_name}.rbtorrent ]; then
      vecho " -n trying to create $j/${trie_name}.rbtorrent: ";

      torrentid=""
      if ! torrentid=$(sky share "${trie_name}"); then
        vecho "failed"
        echo "sky share failed with exit status $?."
        continue;
      fi

      if [ -z "${torrentid}" ]; then
        vecho "failed"
        echo  "got zero torrentid from sky share."
        continue
      fi

      #echo ${torrentid}
      if echo "${torrentid}" > ${trie_name}.rbtorrent; then
        vecho "OK";
      else
        vecho "failed"
        echo "failed write of $j/${trie_name}.rbtorrent"
      fi
      if echo "${rsync_share_path}" | grep -q beta; then
          vecho "registering to beta only"
          beta_only=yes
      else
          vecho "registerint to production and beta"
          beta_only=no
      fi

      register_list=''

      if echo "${querysearch_tries}" | grep -qw "${bare_trie_name}"; then
          if [ "${beta_only}" = "yes" ]; then
              register_list="${register_list} querysearch-beta"
          else
              register_list="${register_list} querysearch querysearch-beta"
          fi
      fi

      if echo "${banflt_tries}" | grep -qw "${bare_trie_name}"; then
          if [ "${beta_only}" = "yes" ]; then
              register_list="${register_list} banflt-beta"
          else
              register_list="${register_list} banflt banflt-beta"
          fi
      fi

      if echo "${twiref_tries}" | grep -qw "${bare_trie_name}"; then
          register_list="${register_list} twiref"
      fi

      if echo "${twisnip_tries}" | grep -qw "${bare_trie_name}"; then
          register_list="${register_list} twisnip"
      fi

      if [ -z "${register_list}" ]; then
          echo "Don't know where to register trie ${bare_trie_name}"
          exit 1;
      fi
      vecho "running DB_DIR=${rsync_share_path} register_banflt_trie.sh \"${bare_trie_name}\" ${register_list}"

      DB_DIR=${rsync_share_path} /home/alximik/alximik_junk/db_updater/examples/register_banflt_trie.sh "${bare_trie_name}" ${register_list}
      vecho "register_banflt_trie.sh exited with $?"

    fi
    vecho "cleaning for ${bare_trie_name} in $j with tag ${tag}";
    find -E . -iregex ".*/${bare_trie_name}\.[[:digit:]-]+(\$|\.rbtorrent\$)" | \
    xargs -n 1 basename | sort -r | awk "
    BEGIN { FS = \"[.]\"; keep_old=4; lines_skipped=0; }
    {
      if ( NF < 3 )
        next
      for (i = NF; i > 0; --i)
          if ((\$i+0) == \$i)
          {
              timestamp=\$i
              break
          }
      if (i == 0)
          next
      if (timestamp < \"${tag}\")
      {
        if (lines_skipped <= keep_old)
        {
          ++lines_skipped
        } else {
          print \$0
        }
      }
    }" | xargs rm -f

  done
done


