#!/bin/sh -eu
#
# Post-xfer rsync hook for moving received via rsync module new packages to our
# pkg repo and generating new index.
#
# $Header$

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin
export PATH

#-- Subroutines --------------------------------------------------------

err()
{
	local _exitval

	_exitval=$1
	shift

	echo 1>&2 "ERROR: $*"
	exit $_exitval
}

usage()
{
	echo 1>&2 "Usage: ${thiscmd} [-r]"
	echo 1>&2 "Options are:"
	echo 1>&2 "  -r            run \`\`pkg repo'' after moving new packages"
	exit 1
}

get_opts()
{
	local _opt

	while getopts "r" _opt; do
		case "$_opt" in
			r) need_index_update=1 ;;
			*) usage ;;
		esac
	done

	shift $(($OPTIND - 1))

	if [ $# -ne 0 ]; then
		usage
	fi
}

check_deps()
{
	local _dir _dir_var

	for _dir_var in module_path backup_path pkg_save_path; do
		eval _dir=\"\$${_dir_var}\"
		if ! [ -d ${_dir} ]; then
			err 1 "${_dir_var} = ${_dir} doesn't exist !"
		fi
	done
}

is_equal()
{
	local _old _new _old_md5 _new_md5

	_old="$1"
	_new="$2"

	_old_md5=$(md5 -q $_old)
	_new_md5=$(md5 -q $_new)

	if [ "${_old_md5}" = "${_new_md5}" ]; then
		return 0
	fi

	return 1
}

move_pkg()
{
	local _pkg _old_pkg _pkg_list _basename _is_updated

	_pkg_list=$(find $module_path -depth 1 -type f -name "*${pkg_sfx}" || \
		echo ${fail_var})
	if [ "${_pkg_list}" = "${fail_var}" ]; then
		err 1 "Can't get list of new packages !"
	fi

	_is_updated=""
	for _pkg in $_pkg_list; do
		if ! pkg info -RF $_pkg >/dev/null; then
			err 1 "Package ${_pkg} is not correct !"
		fi
		_basename=$(basename $_pkg)
		_old_pkg="${pkg_save_path}/${_basename}"
		if [ -f ${_old_pkg} ]; then
			if is_equal $_old_pkg $_pkg; then
				# We have already had this package in repo
				rm -f $_pkg
				continue
			fi
			if ! ln -f $_old_pkg $backup_path; then
				err 1 "Can't backup ${_old_pkg} !"
			fi
		fi
		if ! mv -f $_pkg $pkg_save_path; then
			err 1 "Can't move ${_pkg} to ${pkg_save_path} !"
		fi
		_is_updated="yes"
	done

	if [ -n "${_is_updated}" -a -n "${need_index_update}" ]; then
		if ! pkg repo $pkg_root_path; then
			err 1 "Can't update pkg index !"
		fi
	fi
}


#-- Variables ----------------------------------------------------------

thiscmd=$(basename $0)

fail_var="FAIL"

module_path="${RSYNC_MODULE_PATH}"
backup_path="${module_path}/backup"
pkg_root_path="/usr/local/tinderbox/packages/9.0-FreeBSD_20120220"
pkg_save_path="${pkg_root_path}/All"
pkg_sfx=".txz"

need_index_update=""


#-- Main ---------------------------------------------------------------

get_opts $@
check_deps
move_pkg

