#!/bin/sh -eu

# Usage: ${0##*/} username hostname
#
# This script should be used as a rsyncd post-xfer hook:
#
# 	post-xfer exec = /path/to/rsynchook.sh crawler servername.fb.yandex.ru
#
# Script syncs the same target on slave rsyncd share whenever master share is
# updated. Rsync share with the same name should exist on slave and be
# accessible by username.
#
# rsyncd.conf (5) variables \$RSYNC_MODULE_NAME and \$RSYNC_MODULE_PATH are used.
#
# File /usr/local/etc/rsync/hook_excludes.\$RSYNC_MODULE_NAME is used for
# exclude filters (--exclude-from=...)

U=$1
H=$2

EXCLUDES=/usr/local/etc/rsync/hook_excludes.$RSYNC_MODULE_NAME
ya_os="$(uname -s)"

case "$ya_os" in
	FreeBSD)
		lock_cmd="lockf -kst0"
	;;
	Linux)
		lock_cmd="flock -w0"
	;;
esac

test -s $EXCLUDES || unset EXCLUDES

su -l $U -c "$lock_cmd /var/tmp/rsync-hook.$RSYNC_MODULE_NAME.$H \
	   rsync -rq --contimeout=30 --timeout=300 \
	   --exclude='.?*' \
	   ${EXCLUDES:+--exclude-from=$EXCLUDES} \
	   --password-file=/usr/local/etc/rsync/secret.$U \
	   $RSYNC_MODULE_PATH/ $U@$H::$RSYNC_MODULE_NAME"
