#!/bin/sh

RUNDIR=/place/arcd/run
HOMEDIR=/place/arcd

case "$1" in
start)
	cd $HOMEDIR
	if [ -x /Berkanavt/database/bin/arcdaemon -a -x $HOMEDIR/loop-arcdaemon ] ; then
	else
                echo No binaries >&2
                exit 1
	fi
	if [ -f $RUNDIR/loop-arcd.pid ] && ps -p `cat $RUNDIR/loop-arcd.pid` >/dev/null; then
                echo Already running >&2
                exit 1
	fi

	echo "nohup $HOMEDIR/loop-arcdaemon &" | su -c worm websearch
	;;
stop)
        kill `cat $RUNDIR/loop-arcd.pid`
        sleep 2
        kill `cat $RUNDIR/arcd.pid`
	rm $RUNDIR/*
        ;;
restart)
	kill `cat $RUNDIR/arcd.pid`
        ;;
reopenlog)
	fetch -q -q -q -o /dev/null "http://localhost:18030/ctl?reopenlog"
        ;;

esac


