#!/bin/sh 

# PROVIDE: httpsearch
# REQUIRE: place mountdb 
# KEYWORD: shutdown

. /etc/rc.subr

name="httpsearch"
rcvar=${name}_enable

start_cmd="${name}_start"
stop_cmd="${name}_stop"
restart_cmd="${name}_restart"
load_rc_config $name

: ${httpsearch_enable="YES"}
: ${httpsearch_user="websearch"}
: ${httpsearch_class="yandex"}

mounted="mount | grep -q /db"

_base_dir="/hol/search"
if [ -z "$_file" ]
then
    _bname=`basename $0`
else
    _bname=`basename $_file`
fi
_suff=`expr "${_bname}" : '.*-\([0-9]\{4,\}\).*'`

if [ -z "${_suff}" ]; then
    PORT=8041
    BASE=${_base_dir}
else
    PORT=${_suff}
    BASE="${_base_dir}-${PORT}"
fi

if [ -e ${BASE}/BasePort.conf ];then
	eval `grep -vE "^#" ${BASE}/BasePort.conf` >/dev/null 2>&1
        [ $? -ne 0 ]&&PORT=`awk '$1 ~ /[0-9]+/ {print $1;exit;}' ${BASE}/BasePort.conf`
fi

loop_file="${BASE}/loop-httpsearch"
loop_pidfile="${BASE}/loop-https.pid"
loop_pid=`cat $loop_pidfile`

search_file="${BASE}/httpsearch"
search_pidfile="${BASE}/httpsearch.pid"
search_pid=`cat $search_pidfile`

log_file="/var/log/${name}.log"

s42="/Berkanavt/bin/scripts/s42/s42";
machine=`hostname -s`;


bs_test ()
{
        if ! $s42 instance=/^${machine}:804/ itag=newstyle_upload LIST | grep -q ${machine} ; then
                echo "old style upload"
		true
        else
		echo "not started, because newstyle upload enable"
                exit 0
        fi
}


httpsearch_start()
{

	bs_test;

	date +%s >$log_file

        if [ -x $search_file -a -x $loop_file ] ; then
        else
                echo "No binaries"
                exit 1
        fi
        if [ -f $loop_pidfile ] && ps -p $loop_pid |grep $loop_file >>$log_file ; then
                echo "$name is already running"
                exit 1
        fi
		if eval $mounted 
			then
			else
				echo "mountdb starting.." >>$log_file
				/usr/local/etc/rc.d/mountdb.sh start
		fi
		
		if eval $mounted 
			then
			else
				echo "$name was not started cause mountdb failed to start"
			exit 1
		fi
		
        cd ${BASE} && (echo "nohup $loop_file &" | su -c $httpsearch_class $httpsearch_user) && echo "$name cluster started"
}       

httpsearch_stop()
{
       touch ${BASE}/STOP-HTTPSEARCH
       fetch -q -q -q -o /dev/null "http://localhost:${PORT}/admin?action=shutdown"
       echo;echo -n " ."
       sleep 1
       COUNT=0
       while [ -f ${BASE}/STOP-HTTPSEARCH -a $COUNT -lt 5 -a -z $rc_force ];do
                echo -n " ."
                COUNT=$(($COUNT+1))
                sleep 5
       done
       if [ -f ${BASE}/STOP-HTTPSEARCH ]; then
                echo " Force KILL"
                kill -KILL `cat ${BASE}/httpsearch.pid`
                sleep 1
                rm -f ${BASE}/STOP-HTTPSEARCH
       fi
	echo "$name stopped successfully"
}

httpsearch_restart()
{
        if [ -f $loop_pidfile ] && ps -p $loop_pid | grep -qs $loop_file; then
                kill $search_pid
        else
                run_rc_command "start"
        fi
}

run_rc_command "$1"
