#!/usr/bin/env python

import os
import re
import subprocess
import sys
import time
import statvfs
import socket
import threading
import platform
'''
script for checking amount of tcpdump raw output files

'''
SIZE = 600000  # in packets ~400Mb
DELAY = 1  # seconds
CRITICAL = 30  # minimum free space, program won`t start tcpdump, percents
#MPOINT = "/place/"  # main mount point
TDIR = "/var/tmp"
DIR = TDIR + "/dump/"
ALLSIZE = 6000  # limit total log size can be allocated, in megabytes
LOGCOUNT = 5000  # max nymber of gziped files
NAME = DIR + ("/dump_raw_%s.log" % socket.gethostname())
CFORMAT = "gz"  # gziped files

#IFLIST=os.popen("/bin/cat file.tmp").read().split()

# start thread class


class dumpTr(threading.Thread):

    def __init__(self, iface):
        self.iface = iface

        threading.Thread.__init__(self)
        self._stop = threading.Event()

    def run(self):
            CMD = ("%s -i %s -n -p -c  %d  -w - >> %s  " %
                   (_td_bin, iface, SIZE, NAME))
            proc = subprocess.Popen(CMD, shell=True)
            #os.popen("touch /tmp/dump/dump_raw_bsd.log.0")
            # mv filename.log  -> filename.log.0 if filename.log.0 not exist
            proc.wait()
            zName = NAME + ".0"
            if not os.path.isfile(zName):
                CMD = ("%s %s %s " % (_mv_bin, NAME, zName))
                proc = subprocess.Popen(CMD, shell=True)
                proc.wait()
                # else do nothing

    def stop(self):
        self._stop.set()

# end of class
#  logger class


class watchDog(threading.Thread):
    def __init__(self, maxfiles):
        self.maxfiles = maxfiles

        self.listfiles = []  # files in file.log.0.gz format

        threading.Thread.__init__(self)
        self._stop = threading.Event()

    def run(self):

        time.sleep(2)

    def clean(self):
        for filename in os.listdir(DIR):
            pattern = re.compile('\.(\d+)\.%s$' % CFORMAT)
            matched = pattern.search(filename)

            if matched:
                #make operation list
                self.listfiles.append(filename)

                if int(matched.group(1)) >= self.maxfiles:
                    #print("%s/%s :deleted" % (DIR,filename))
                    os.remove("%s/%s" % (DIR, filename))

    def rotate(self):
        count_down = self.maxfiles - 1
        while count_down >= 0:
            for item in self.listfiles:
                pattern = re.compile('\.((\d+)\.%s)$' % CFORMAT)
                matched = pattern.search(item)
                if int(matched.group(2)) == count_down:
        #        print("%s/%s :moved" % (DIR,item))
                    string = (item[:-len(matched.group(1))] +
                              str((count_down + 1)) +
                              "." +
                              CFORMAT)
                    src = DIR + "/" + item
                    dst = DIR + "/" + string
                    if os.path.isfile(src):
                        CMD = "%s %s %s" % (_mv_bin, src, dst)
                        proc = subprocess.Popen(CMD, shell=True)
                        proc.wait()
            count_down -= 1

    def run(self):
        self.clean()
        zName = NAME + ".0"
        if os.path.isfile(zName):
            self.rotate()
            CMD = "%s %s " % (_gzip_bin, zName)
            proc = subprocess.Popen(CMD, shell=True)
            proc.wait()

    def stop(self):
        self._stop.set()

# end of class


def freespace(partition):
    f = os.statvfs(partition)
    free = float((f.f_bavail * f.f_frsize) / 1024 / 1024)  # megabytes
    total = float((f.f_blocks * f.f_frsize) / 1024 / 1024)
    percent = free / (total / 100)
    space = int(percent)
    return space

#---
# Main part
#---

_os_type = platform.system()
_mv_bin = '/bin/mv'
_gzip_bin = '/usr/bin/gzip'
_td_bin = '/usr/sbin/tcpdump'
_pwd_bin = '/bin/pwd'

IFLIST = []
PARTITION = os.popen("cd %s && %s -P " % (TDIR, _pwd_bin)).read()

if PARTITION:
    p_arr = PARTITION.split('/')
    PARTITION = "/" + p_arr[1]
else:
    print("Error: No valid partition")
    exit(1)

if _os_type == 'Linux':
    _gzip_bin = '/bin/gzip'
    IFLIST = os.popen(
        "/sbin/ifconfig -s |/bin/grep eth |/usr/bin/awk '{print $1}'"
        ).read().split()

elif _os_type == 'FreeBSD':
    IFLIST = os.popen("/sbin/ifconfig -l -u").read().split()  # bsd version
else:
    print("Error: Unknown os")
    os._exit(1)


for iface in IFLIST:
    p = re.compile('ipfw*|lo*|vlan*')
    if not p.match(iface):
        IF = iface
        break  # find first active and exit

if not IF:
    print("Error: Iface not found")
    os._exit(1)

pidf = open('/var/run/td_control.pid', 'w')
if os.path.isfile("/var/run/td_control.pid"):
    pidf.write(str(os.getpid()))
    pidf.close()
#os.popen("echo %s > /var/run/td_control.pid" % os.getpid()):
else:
    print("Error: Can`t create pid file")
    sys.exit(1)

if not os.path.exists(DIR):
    try:
        os.makedirs(DIR)
    except OSError, e:
        print(e)
        sys.exit(1)


logcount = LOGCOUNT

d = dumpTr(IF)
d.start()

w = watchDog(logcount)
w.start()

#logcount = 30 # default value


while True:
    time.sleep(1)
    if not w.isAlive():
        w = watchDog(logcount)
        w.start()

    if freespace(PARTITION) < CRITICAL:
        if logcount > 5:
            logcount -= 5
#        d.join()
#        d.stop()
#        sys.stderr.write('Not enough disk space at %s \n' %MPOINT)
#        exit(1);
    else:
        if not d.isAlive():
            #
            print("nope")
            d = dumpTr(IF)
            d.start()
        else:
            print("running")
            time.sleep(1)
