#!/usr/bin/awk -f
#
# For the reference: https://jira.yandex-team.ru/browse/SEARCHADMIN-1560
#

BEGIN {
	fwurl="svn+ssh://arcadia.yandex.ru/adm/trunk/nalivki/Linux/templates/spider/etc/iptables/sets"
	fwpath="/place/nalivki/Linux/templates/spider/etc/iptables/sets"

	"mktemp -d /tmp/autopf.XXXX" | getline root
	fwp = root "/fw/"
	tmp = root "/tmp/"
	tsxlt = tmp "transform.xslt"
	lsxml = tmp "logsubs.conf.xml"

	lsurl = "svn+ssh://arcadia.yandex.ru/arc/branches/zora/zora-stable-2015-00/arcadia/yweb/robot/spider/environments/+ASPIDER/logsubs.conf.xml"
	url80 = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/common/roboconf/fw/allow-80"
	url84 = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/common/roboconf/fw/allow-80_443"

	svnvar = "export SVN_SSH=\"ssh -q -l search-spider-rw -i /Berkanavt/search-spider-rw/search-spider-rw\""
	svnexp  = svnvar " && svn export -q --non-interactive"
	svncat  = svnvar " && svn cat --non-interactive"
	svnco   = svnvar " && svn co -q --non-interactive"
	svninfo = svnvar " && svn info --non-interactive"
	svnst   = svnvar " && svn status --non-interactive"
	svnci   = svnvar " && svn ci --username search-spider-rw -q --non-interactive -m \"auto commit from $(hostname):update-spider-fw-tables.sh\""
	svnup   = svnvar " && svn up -q --non-interactive"


	##
	##  Prepare directories
	##
	if (system("mkdir -p " fwp " " tmp))
		_err("cannot create directories " fwp ", " tmp)


	##
	##  Checkout svn urls and check paths
	##
	if (system(svnco " " fwurl " " fwp))
		_err("cannot checkout from url " fwurl)
	_checksvn(fwpath, fwurl)
	_checksvn(fwp, fwurl)
	_checksvn(lsurl, lsurl)


	##
	##  spiders_v{4,6}
	##
	str = _cond("search_robot_zora-rtspider search_robot_zora-rtspiderdev " \
			"search_robot_zora-spider search_robot_zora-spiderdev " \
			"search_robot_zora-zora search_robot_zora-zoradev")
	sts = str
	gsub(/yandex\.com/, "search.yandex.net", sts)
	##
	##
	_write(_get("_SEARCHMLSPIDERNETS_") _get("_SPIDERNETS_") _get(str) _get(sts) _get("127.0.0.1 :: ::1"), "spiders")


	##
	##  subs_v{4,6}
	##
	print	"<?xml version=\"1.0\"?>\n" \
		"<xsl:stylesheet version=\"1.0\"\n" \
		"	xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n" \
		"	xmlns:str=\"http://exslt.org/strings\">\n\n" \
		"	<xsl:output method=\"text\"/>\n" \
		"	<xsl:template match=\"/\">\n" \
		"		<xsl:apply-templates select=\"//writer[@type='MsgBus']\" mode=\"dump\"/>\n" \
		"	</xsl:template>\n\n" \
		"	<xsl:template match=\"//writer\" mode=\"dump\">\n" \
		"		<xsl:value-of select=\"param[@name='Destination']/@value\"/>\n" \
		"	 	<xsl:text>&#xa;</xsl:text>\n" \
		"	</xsl:template>\n\n" \
		"</xsl:stylesheet>" > tsxlt
	close(tsxlt)
	system(svnexp " " lsurl " " lsxml)
	str = _cmd("xsltproc " tsxlt " " lsxml)
	gsub(/:[0-9]+/, "", str)
	##
	##
	_write(_get(str), "subs")
	system("rm -f " tsxlt " " lsxml)


	##
	##  mr_v{4,6}
	##
	_write(_get("_MRPROXY01SRV_"), "mr")


	##
	##  pub_v{4,6}
	##
	_write(_get("_SLBPUBLICSUPERNETS_"), "pub_slb")


	##
	##  svn_v{4,6}
	##
	_write(_get("_ARCADIASVN_") _get("tree.yandex.ru"), "svn")


	##
	##  wo_slb_http_v{4,6}
	##
	_write(_get("_PERSONALPROJECTNETS_") _get(_cmd(svncat " " url80)), "wo_slb_http")


	##
	##  wo_slb_https_v{4,6}
	##
	_write(_get("_PERSONALPROJECTNETS_") _get(_cmd(svncat " " url84)), "wo_slb_https")


	##
	##  yandex_v{4,6}
	##
	_write(_get("_YANDEXNETS_"), "yandex")


	##
	##  Distribute (to svn and fwpath)
	##
	if (length(_cmd(svnst " " fwp)))
		system(svnci " " fwp " && " svnup " " fwpath)


	##
	##  Cleanup
	##
	if (system("rm -rf " root))
		_err("cannot delete " root)
}


#=====================================================================================================


function _checksvn(p, u,    A, cmd)
{
	cmd = svninfo " " p
	while ((cmd | getline A) > 0 && A !~ /^URL: /) ;
	close(cmd)

	if (sub(/^URL: /, "", A) && A == u)
		return
	else
		_err("the path " p " doesn't conform SVN URL " u)
}


#=====================================================================================================


function _write(A, F,     cmdv4, cmdv6)
{
	cmdv4 = "sort -un -t. -k1,1 -k2,2 -k3,3 -k4,4 > " fwp F "_v4"
	cmdv6 = "sort -u -t: > " fwp F "_v6"

	split(A, ar)
	for (i in ar)
		if (ar[i] ~ /^[0-9]+\.[0-9]+\.[0-9]+\.+[0-9]+(\/[0-9]+)?$/)
			print ar[i] | cmdv4
		else if (ar[i] ~ /^[a-f0-9:]+(\/[0-9]+)?$/)
			print ar[i] | cmdv6

	close(cmdv4)
	close(cmdv6)
}


#=====================================================================================================


function _get(A,    n, i, c, r, ar)
{
	n = split(A, ar)
	r = ""
	for (i = 1; i <= n; i++)
	{
		c = _resolv(_expand(ar[i]))
		if (length(c))
			r = r c "\n"
	}

	return r
}


#=====================================================================================================


function _resolv(A,    m, n, i, j, ar, ap, ip)
{
	n = split(A, ar)
	for (i = 1; i <= n; i++)
	{
		if (ar[i] ~ /^([0-9]+\.[0-9]+\.[0-9]+\.+[0-9]+|[a-f0-9:]+)(\/[0-9]+)?$/)
			ip = ip "\n" ar[i]
		else
		{
			m = split(_cmd("dig " ar[i] " A +short & dig " ar[i] " AAAA +short &"), ap)
			for (j = 1; j <= m; j++)
				if (ap[j] ~ /^([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+|[a-f0-9:]+)$/)
					ip = ip "\n" ap[j]
		}
	}

	return substr(ip, 2)
}


#=====================================================================================================


function _cond(s,    ar, i, r)
{
	split(s, ar)
	for (i in ar)
		r = r " http://c.yandex-team.ru/api/groups2hosts/" ar[i] 

	return _cmd("curl -qs " r)
}


#=====================================================================================================


function _cmd(cmd,    A, r)
{
	while ((cmd | getline A) > 0)
	{
		gsub(/[ \t]*(#.+)?$/, "", A)
		if (length(A) > 0)
			r = r "\n" A
	}
	close(cmd)


	return substr(r, 2)
}


#=====================================================================================================


function _expand(A,    cmd, r, n, i, ar)
{
	if (A !~ /^_[A-Z0-9_]+_$/)
		return A

	r = _cmd("wget -qO - http://golem.yandex-team.ru/api/firewall/expand_macro.sbml?macro=" A)
	if (r !~ /^ok/)
		_err("bad golem answer " r)


	n = split(r, ar)
	r = ""
	for (i = 1; i <= n; i++)
		if (ar[i] !~ /^(ok|or)$/)
		{
			if (ar[i] ~ /^_[A-Z0-9_]+_$/)
				r = r "\n" _expand(ar[i])
			else
				r = r "\n" ar[i]
		}

	return substr(r, 2)
}


#=====================================================================================================


function _err(A)
{
	print "ERROR: " A
	exit 1
}
