#!/bin/sh -e
#
# Script for updating robot metrics.
#
# $Id$

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin
SVN_SSH=/Berkanavt/bin/scripts/svn_ssh
export PATH SVN_SSH

#-- Subroutines --------------------------------------------------------

err()
{
	local _exitval

	_exitval=$1
	shift

	_d=$(date "+%F %T")
	echo 1>&2 "[${_d}] ERROR: $*"
	exit $_exitval
}

info()
{
	_d=$(date "+%F %T")
	echo "[${_d}] INFO: $*"
}

check_depends()
{
	local _user

	if [ ! -f "${ctl_file}" ]; then
		exit 0
	fi

	_user=$(stat -f %Su ${ctl_file} 2>/dev/null || echo UNDEF)

	if ! ( echo "${ctl_users}" | grep -qw "${_user}" 2>/dev/null )
	then
		err 1 "Unpermitted user ${_user} is trying to do update."
	fi
}

cleanup()
{
	# Following command must be synchronized with sudoers(5)
	if ! sudo rm -f ${ctl_file}; then
		err 1 "Can't remove ${ctl_file} !"
	fi
}

set_upd_args()
{
	branch=$(grep -m 1 -Eo "[a-z0-9-]+" ${ctl_file} || echo UNDEF)

	if [ "${branch}" = "UNDEF" ]; then
		info "Branch is not defined, use 'svn up'."
		svn_args="up"
		return 0
	fi

	scripts_url=$(echo "${scripts_url_tpl}" | \
		sed -e "s/<branch>/${branch}/")
	svn_args="sw ${scripts_url}"

	info "Update URL is ${scripts_url}"
}

update()
{
	if ! cd $scripts_dir; then
		err 1 "Can't change dir to ${scripts_dir} !"
	fi

	if ! svn $svn_args; then
		err 1 "Can't update metrics !"
	fi

	if ! find ${scripts_dir} -user $(id -un) -exec chmod ug+w {} \;
	then
		err 1 "Can't fix permissions !"
	fi

	info "Metrics have been updated."
}

runonce()
{
	if [ -x ${runonce_script} ]; then
		if ! $runonce_script; then
			err 1 "Script ${runonce_script} has returned" \
				"error !"
		fi
		info "\"Runonce\" procedure has been done."
	fi
}


#-- Variables ----------------------------------------------------------


ctl_file="/var/tmp/upd_metrics"	# Check sudoers(5) please if you're
				# going to change this variable
ctl_users="root|rdna|blaze|vlevkevich"	# "|"-separated list

scripts_url_tpl="svn+ssh://arcadia.yandex.ru/arc/branches/<branch>/arcadia/yweb/robot/metrics/robotmon"
scripts_dir="/Berkanavt/robotmon/scripts/"
runonce_script="${scripts_dir}/runonce.sh"


#-- Main ---------------------------------------------------------------

check_depends

trap cleanup EXIT

set_upd_args
update
runonce

