#!/bin/sh
#set -x
set -e

case $TERM in
  xterm|screen*|*rxvt)
      Black='\033[00;30m';
      Blue='\033[00;34m';
      Green='\033[00;32m';
      Cyan='\033[00;36m';
      Red='\033[00;31m';
      Purple='\033[00;35m';
      Brown='\033[00;33m';
      LGray='\033[00;37m';
      DGray='\033[01;30m';
      LBlue='\033[01;34m';
      LGreen='\033[01;32m';
      LCyan='\033[01;36m';
      LRed='\033[01;31m';
      LPurple='\033[01;35m';
      Yellow='\033[01;33m';
      White='\033[01;37m';
      Normal='\033[00m';
    ;;
  *)
      Black='';
      Blue='';
      Green='';
      Cyan='';
      Red='';
      Purple='';
      Brown='';
      LGray='';
      DGray='';
      LBlue='';
      LGreen='';
      LCyan='';
      LRed='';
      LPurple='';
      Yellow='';
      White='';
      Normal='';
    ;;
esac


die()
{
    printf "${Red}Error: $@${Normal}\n" >&2
    exit 1
}

warn()
{
    if [  -n "$1" ]; then
          printf "${Brown}Warn: $@${Normal}\n" >&2 
    fi
}



me=$( basename $0 )
CONFIG_DIR="/place/jail_configs"
JAIL_DIR="/place/jail"
JAILNAME="$1"
JAILFULLNAME="${JAILNAME}.yandex.ru"

preserve_list="place/berkanavt place/home"


printf "${Cyan}Phase 0: Gathering system info.${Normal}\n"

[ -z $1 ] && die "usage $me JAILNAME" >&2

[ ! -d $CONFIG_DIR ] &&  die "CONFIG_DIR=$CONFIG_DIR not found" >&2

[ ! -d $JAIL_DIR ] && die "JAIL_DIR=$JAIL_DIR not found" >&2


echo "Updating jail: "$JAILNAME
ROOTHOST=`hostname` 
ROOTIP=`host $ROOTHOST | grep address | awk '{print $4}'`
JAILIP=`host ${JAILFULLNAME} | grep address | awk '{print $4}'`


for i in `ifconfig -l | tr [" "] ["\n"] | egrep -e 'em|bce|bge|igb'`;
do A=`ifconfig $i | grep status | awk -F: '{print $2}'`; 
    if [ "${A}" = " active" ];
    then 
        INTF=$i;
    fi;
done

ANYIP=$(host -c IN -t A any.yandex.ru  | head -n 1 | awk ' { print $NF; } ')

[ -n "${ANYIP}" ] || die 1 'failed resolving any.yandex.ru'

if [ $JAILIP = $ANYIP ]; 
then
    die "This jailname \"$JAILFULLNAME\" is not reconized in dns" >&2
fi

printf "  JAILIP=${JAILIP}\n"
printf "  ROOTIP=${ROOTIP}\n"
printf "  ROOTHOST=${ROOTHOST}\n"


printf "${Cyan}Phase 1: Gathering jail info.${Normal}\n"

[ -r ${CONFIG_DIR}/jail_users ] || die "  ${CONFIG_DIR}/jail_users is not readable."

jail_info=$( cat ${CONFIG_DIR}/jail_users | grep ${JAILNAME} ) || die " failed to grep ${JAILNAME} from ${CONFIG_DIR}/jail_users"
jail_owner=$( echo ${jail_info} | awk ' { print $2; } ' || true )
jail_roots=$( echo ${jail_info} | awk ' { for ( i=2; i <= NF; ++i) printf $i" ";  }' || true )

if [ -z $jail_owner ] ||  ! echo ${jail_owner} | grep -q 'yandex-team' ; then
  die "  failed to find jail owner. got [ $jail_owner ]."
fi

echo "  jail_owner=${jail_owner}"
echo "  jail_roots=${jail_roots}"

jail_exists="no"
jail_running="no"

printf "  checking if jail exists ... "
if [ -d ${JAIL_DIR}/$JAILNAME ]; then
  jail_exists="yes"
fi
printf "$jail_exists \n"
if [ x$jail_exists = xyes ]; then
  printf "  checking if jail is running ... "

  jail_list=$( jls -a | sed 1d )

  jail_string=$( echo "$jail_list" | grep ${JAILFULLNAME} || true )
  if [ -z "$jail_string" ]; then
    jail_running="No"
  else
    running_jail_id=$( echo ${jail_string} | awk ' { print $1;} ') 
    running_jail_ip=$( echo ${jail_string} | awk ' { print $2;} ') 
    running_jail_name=$( echo ${jail_string} | awk ' { print $3;} ')
    running_jail_dir=$( echo ${jail_string} | awk ' { print $4;} ')

    [ x"$running_jail_name" != x"$JAILFULLNAME" ] && die "  something went wrong --- grepped string [ $jail_string ] for jail $JAILFULLNAME."

    [ x"$running_jail_ip" != x"$JAILIP" ] && die "  running jail ip [${running_jail_ip}] differs from found record [${JAILIP}]"

    [ x"$running_jail_dir" != x"${JAIL_DIR}/$JAILNAME" ] && die "  running jail dir [${running_jail_dir}] differs from expected [${JAIL_DIR}/$JAILNAME]."

    jail_running="yes"
  fi
  printf "$jail_running \n"
fi


if ! [ x$jail_exists = xyes ]; then
  printf "${Cyan}Phase 2: Creating jail.${Normal}\n"

  mkdir -p ${JAIL_DIR}/$JAILNAME

  [ -d ${CONFIG_DIR}/$JAILNAME ] && die "  failed creating jail because backup dir [ ${CONFIG_DIR}/$JAILNAME ] exists."

  mkdir -p ${CONFIG_DIR}/$JAILNAME || dir "  failed creating dir [ ${CONFIG_DIR}/$JAILNAME ] with error $?."

  for item in $preserve_list; do
    printf "  Creating $item ... "
    mkdir -p ${CONFIG_DIR}/${JAILNAME}/${item}
    cd /$item; tar -cf - . | (cd ${CONFIG_DIR}/${JAILNAME}/${item}; tar -xpf -) || die "  failed to create $item "
    printf "done. \n"
  done

  #printf "  Copy home-directory ... "
  #cd /place/home; tar -cf - . | (cd /${JAIL_DIR}/${JAILNAME}/place/home/; tar -xpf -) || dir " failed to copy home"
  #printf "${Green}done${Normal}. \n"
else
  printf "${Cyan}Phase 2: Stopping jail.${Normal}\n"
  if [ x$jail_running = xyes ]; then
     /etc/rc.d/jail stop ${JAILNAME} || die "  failed to stop jail [$JAILNAME]"
  fi
  printf "${Cyan}Extracting backup data from jail${Normal}.\n"
  [ ! -d "${CONFIG_DIR}/${JAILNAME}" ] && mkdir "${CONFIG_DIR}/${JAILNAME}"

  preserve_source=${JAIL_DIR}/${JAILNAME}
  preserve_sink=${CONFIG_DIR}/${JAILNAME}
  for file in $preserve_list; do 
    src=${preserve_source}/$file
    dst=${preserve_sink}/$file

    mkdir -p $( dirname $dst )

    if [ -e $src ] && [ -e $dst ]; then
      die "  failed to backup [ $src ], because [ $dst ] exists."
    fi

    if [ -e $src ]; then
      mv $src $dst
    fi

    echo "  moved $src ---> $dst"
  done
fi

printf "${Cyan}Phase 3: destroying old jail${Normal}.\n"
# "`mount | grep $JAILNAME`" != "" ] && umount /place/jail/$JAILNAME/place/hol 
chflags -R 0 ${JAIL_DIR}/$JAILNAME
rm -rf ${JAIL_DIR}/$JAILNAME/*

printf "${Cyan}Phase 4: creating new jail${Normal}.\n"
printf "  copying root ... "
cd ${JAIL_DIR}/$JAILNAME && dump -a -0 -f- / | restore -r -f- ||  die "  failed to dump & restore root fs."
rm restoresymtable

printf "done. \n"

printf "  copying var ... "
cd ${JAIL_DIR}/$JAILNAME/var && dump -a -0 -f- /var | restore -r -f- ||  die "  failed to dump & restore var fs."
rm restoresymtable
printf "done. \n"

printf "  Copy /place/hol ... "
[ ! -d ${JAIL_DIR}/${JAILNAME}/place/hol ] && mkdir ${JAIL_DIR}/${JAILNAME}/place/hol
cd /place/hol; tar -cf - . | (cd ${JAIL_DIR}/${JAILNAME}/place/hol; tar -xpf -) || die "  failed to copy root".
printf "done. \n"


#cd /place/usr_local_scripts; tar -cf - . | (mkdir -p /place/jail/${JAILNAME}/place/usr_local_scripts/;cd /place/jail/${JAILNAME}/place/usr_local_scripts/; tar -xpf -)


### Make some work direcotrys ###
for i in coredumps vartmp; do 
  mkdir -p ${JAIL_DIR}/$JAILNAME/place/$i; 
  chmod 777 ${JAIL_DIR}/$JAILNAME/place/$i; 
done

printf "${Cyan}Phase 5: restoring backups${Normal}.\n"
restore_sink=${JAIL_DIR}/${JAILNAME}
restore_source=${CONFIG_DIR}/${JAILNAME}
for file in $preserve_list; do 
  dst=${restore_sink}/$file
  src=${restore_source}/$file

  mkdir -p $(dirname dst)

  if [ -e $dst ]; then
    die "  failed to restore backup [ $src ], because [ $dst ] exists."
  fi

  if [ ! -e $src ]; then
    die "  failed restoring [ $src ]. item does not exist."
  fi
  
  mv $src $dst || die "  failed to restore backup [ $src ] to [ $dst ]. \"mv\" returned $? "

  echo "  moved $src ---> $dst"
done

printf "${Cyan}Phase 6: updating host system configs${Normal}.\n"

if [ -z "`grep "ListenAddress" /etc/ssh/sshd_config | grep -v ^#`" ]
then
    echo "ListenAddress $ROOTIP" >> /etc/ssh/sshd_config
else
    sed -i -e  "s/ListenAddress.*/ListenAddress $ROOTIP/" /etc/ssh/sshd_config 
fi
/etc/rc.d/sshd restart

if [ "`grep jail_enable /etc/rc.conf`" != 'jail_enable="YES"'  ]  
then
    if [ -z "`grep jail_enable /etc/rc.conf`" ]
    then
      echo 'jail_enable="YES"' >> /etc/rc.conf
      echo 'jail_socket_unixiproute_only="NO"' >> /etc/rc.conf
      echo 'jail_sysvipc_allow="YES"' >>  /etc/rc.conf
    else
      sed -i -e  's/jail_enable.*/jail_enable="YES"/' /etc/rc.conf 
    fi
fi

if [ "`grep nisdomainname /etc/rc.conf`" != 'nisdomainname="yandex-search"'  ]
then
	if [ -z "`grep nisdomainname /etc/rc.conf`" ]
	then
		echo 'nisdomainname="yandex-search"' >> /etc/rc.conf
	else
		sed -i -e  's/nisdomainname.*/nisdomainname="yandex-search"/' /etc/rc.conf 
	fi
	/etc/rc.d/nisdomain start
fi

#sed -i -e 's/nosuid,//' /etc/fstab

if [ "`grep jail_${JAILNAME}_rootdir /etc/rc.conf`" != 'jail_${JAILNAME}_rootdir="/place/jail/${JAILNAME}"'  ]  
then
    if [ -z "`grep jail_${JAILNAME}_rootdir /etc/rc.conf`" ]
    then
              cat << EOF >> /etc/rc.conf
jail_${JAILNAME}_rootdir="/place/jail/${JAILNAME}"
jail_${JAILNAME}_devfs_enable="YES"
jail_${JAILNAME}_procfs_enable="YES"
jail_${JAILNAME}_exec_start="/bin/sh /etc/rc"
jail_${JAILNAME}_exec_stop="/bin/sh /etc/rc.shutdown"
jail_${JAILNAME}_hostname="${JAILNAME}.yandex.ru"
jail_${JAILNAME}_ip="${JAILIP}"
jail_${JAILNAME}_interface="$INTF"
EOF
    else
      perl  -e  '$JAILNAME=$ARGV[0];$JAILIP=$ARGV[1]; $INTF=$ARGV[2];open(A,"</etc/rc.conf") || die"can not open file rc.conf"; while(<A>){ s/jail_luke2_rootdir.*/jail_luke2_rootdir="\/place\/jail\/$JAILNAME"/;s/jail_${JAILNAME}_devfs_enable.*/jail_${JAILNAME}_devfs_enable="YES"/;s/jail_${JAILNAME}_procfs_enable.*/jail_${JAILNAME}_procfs_enable="YES"/;s/jail_${JAILNAME}_exec_start.*/jail_${JAILNAME}_exec_start="\/bin\/sh \/etc\/rc"/;s/jail_${JAILNAME}_exec_stop.*/jail_${JAILNAME}_exec_stop="\/bin\/sh \/etc\/rc.shutdown"/;s/jail_${JAILNAME}_hostname.*/jail_${JAILNAME}_hostname="${JAILNAME}.yandex.ru"/;s/jail_${JAILNAME}_ip.*/jail_${JAILNAME}_ip="${JAILIP}"/;s/jail_${JAILNAME}_interface.*/jail_${JAILNAME}_interface="$INTF"/;print; };close(A);' $JAILNAME $JAILIP $INTF > /etc/rc.conf.tmp  && mv  /etc/rc.conf.tmp /etc/rc.conf

      #sed -e  's/jail_enable.*/jail_enable="YES"/' /etc/rc.conf > /etc/rc.conf.tmp && mv  /etc/rc.conf.tmp /etc/rc.conf
    fi
fi

 cat << EOF > /etc/devfs.rules
[devfsrules_jail=4]
add include \$devfsrules_hide_all
add include \$devfsrules_unhide_basic
add include \$devfsrules_unhide_login
add path 'bpf*' unhide mode 0644
EOF

printf "${Cyan}Phase 7: updating jail configs${Normal}.\n"

echo -e "ipaddr=\"${JAILIP}\"\nhostname=\"${JAILFULLNAME}\"" > /${JAIL_DIR}/${JAILNAME}/etc/rc.conf.local

for file in rc.conf rc rc.shutdown crontab; do 
  echo -n "   installing $file ... "
  cp -a ${CONFIG_DIR}/default_$file ${JAIL_DIR}/${JAILNAME}/etc/${file} || die " failed installing ${file}."
  printf "done\n"
done

echo -n "   installing sshd_config ... "
sed -e  's/ListenAddress.*//' ${JAIL_DIR}/${JAILNAME}/etc/ssh/sshd_config > ${JAIL_DIR}/${JAILNAME}/etc/ssh/sshd_config.tmp && mv ${JAIL_DIR}/${JAILNAME}/etc/ssh/sshd_config.tmp ${JAIL_DIR}/${JAILNAME}/etc/ssh/sshd_config || die "  failed installing sshd_config"
printf "done\n"

echo -n "   disabline rem  ... "
echo 'rem_enable="NO"' > ${JAIL_DIR}/${JAILNAME}/etc/rc.conf.d/rem || die "  failed disabling rem. exit status [ $? ]"
printf "done\n"

echo -n "   disabling rem crontab ... "
echo '' > ${JAIL_DIR}/${JAILNAME}/var/cron/allow || die "  failed disabling rem crontab. exit status [ $? ]"
printf "done\n"

echo -n "   clearing rem cache ... "
for dir in backups packets log var; do
 if [ -d ${JAIL_DIR}/${JAILNAME}/place/berkanavt/rem/$dir ]; then
   ls ${JAIL_DIR}/${JAILNAME}/place/berkanavt/rem/$dir/ | xargs -n 1 rm -rf || die "  failed clearing /place/berkanavt/rem/$dir/ . exit status [ $? ]"
  fi
done
printf "done\n"


for jail_root in ${jail_roots}; do 
  echo -n "   giving root to ${jail_root} ... "
  #line below breaks sudoers uniformity
  #echo "${jail_root%%@*}  ${JAILNAME} = (ALL) NOPASSWD: ALL" >> ${JAIL_DIR}/${JAILNAME}/usr/local/etc/sudoers || die "  failed updating sudoers"
  sed -i.bak 's/wheel:\*:0:root,/wheel:*:0:root,'"${jail_root%%@*}"',/g' ${JAIL_DIR}/${JAILNAME}/etc/group
  printf "done\n"
done


mount -t devfs foo ${JAIL_DIR}/${JAILNAME}/dev || true
chroot ${JAIL_DIR}/${JAILNAME} /Berkanavt/bin/datascripts/test_environment/init_twin.py --origin veles --owner $jail_owner --hostname $JAILFULLNAME || true
umount -f ${JAIL_DIR}/${JAILNAME}/dev || true



#sed -e "s/127.0.0.1/${ROOTIP}/" /place/jail/${JAILNAME}/etc/resolv.conf > /place/jail/${JAILNAME}/etc/resolv.conf.tmp && mv /place/jail/${JAILNAME}/etc/resolv.conf.tmp /place/jail/${JAILNAME}/etc/resolv.conf
#cp /etc/resolv.conf /place/jail/${JAILNAME}/etc/
### Make resolv.conf ###

NETNUM=`. /etc/ya.subr;. /etc/rc.conf.local;export $(ya_network_info $ipaddr); printf %.3d $ya_net_num`;
host net-$NETNUM.porter.yandex.ru | awk 'BEGIN {print "domain  yandex.ru"} {print "nameserver\t"$4} END {print "nameserver\t77.88.26.253\noptions timeout:1 attempts:1"}'  > /tmp/resolv.conf 
if [ -s /tmp/resolv.conf ]
then 
	mv /tmp/resolv.conf ${JAIL_DIR}/${JAILNAME}/etc/
else
	cp /etc/resolv.conf ${JAIL_DIR}/${JAILNAME}/etc/
fi

#sed -i -e 's/.*pam_mkhomedir.so.*/session         required        \/usr\/local\/lib\/pam_mkhomedir.so        mode=0755 debug/' ${JAIL_DIR}/${JAILNAME}/etc/pam.d/sshd
sed -i -e 's/.*radius.*/auth            sufficient  pam_radius.so       try_first_pass/' ${JAIL_DIR}/${JAILNAME}/etc/pam.d/sshd

RADIUSSERV=`host net-$NETNUM.porter.yandex.ru | awk '{print $4}' | xargs -I name host name | awk '{print $5}' | sed -e 's/.$//' | tr "\n" "," | sed -e 's/,$//'`

sed -i -e '/nis_client_flags.*/d' ${JAIL_DIR}/${JAILNAME}/etc/rc.conf
echo 'nis_client_flags="-s -m -S yandex-search,porter.yandex.ru,'${RADIUSSERV}' -ypset"' >> ${JAIL_DIR}/${JAILNAME}/etc/rc.conf

#JN=`echo ${JAILNAME} | tr [a-z] [A-Z]` 
#echo -e "+@${JN}:::::::::\n+:*:::::::/tmp/emptyhome:/sbin/nologin\n" >> /place/jail/${JAILNAME}/etc/master.passwd
#pwd_mkdb -p -d /place/jail/${JAILNAME}/etc /place/jail/${JAILNAME}/etc/master.passwd


chmod 444 /${JAIL_DIR}/${JAILNAME}/etc/rc.d/place
#mount -t unionfs -o below /place/hol /place/jail/${JAILNAME}/place/hol
#mount -t unionfs /place/home /place/jail/${JAILNAME}/place/home
#[ "`grep ${JAILNAME} /etc/fstab | grep hol`" = "" ] && echo "/place/hol  /place/jail/${JAILNAME}/place/hol    unionfs below,rw  0   0" >> /etc/fstab

printf "${Cyan}Phase 8: updating berkanavt${Normal}.\n"
echo "/place/berkanavt ${JAIL_DIR}/${JAILNAME}/place/"
rsync="rsync -a /place/berkanavt ${JAIL_DIR}/${JAILNAME}/place/"
echo running $rsync
$rsync || die "  rsync exited with error code [ $? ] "

printf "${Cyan}Phase 9: starting jail${Normal}.\n"

/etc/rc.d/jail start ${JAILNAME}



printf "Done\n"
