#!/usr/bin/env python

# tiny  xml parser for monitoring and ipfw services
# author: kfour@yandex-team.ru
#


import re
import sys
import getopt
import random

from xml.dom.minidom import parseString



try:
    options, args = getopt.getopt(sys.argv[1:], "d:t:h", ["tag=","help"])
except getopt.GetoptError, err:
    print str(err) # will print something like "option -a not recognized"
    sys.exit(2)

tag = ""
delimeter = "\n"

for opt,arg  in options:
    if opt in ("-t","--tag"):
        tag = arg
    if opt in ("-d"):
        delimeter = arg
    elif opt in ("-h", "--help"):
        print("   -h   this help\n   -t   tag name\n   -d   delimeter, newline by default")
        print("   Usage: cat file.xml | xmlgettag.py -t port -d ',' ")
        print("  Output:  17313,17061,17317,17094,17075,17079,17314,17073,17100,17000 ")

        sys.exit(1)

data = sys.stdin.read()
data = str(data)

out = ""

dom = parseString(data)
name = dom.getElementsByTagName(tag)

#print name[]

i = 0
while (i < len(name)):
    val = " ".join(t.nodeValue for t in name[i].childNodes if t.nodeType == t.TEXT_NODE)
    i += 1
    out +=val+delimeter


print out.strip(delimeter)
