#!/bin/sh
set -x

# Prereq: cd /Berkanavt/webscripts/admscripts/scripts/startup && cvs up -dP
# Exec: sudo ./ya_subr_update.sh >ya_subr_debug.log 2>&1

YA_SUBR_TEST=/Berkanavt/webscripts/admscripts/scripts/startup
YA_SUBR_STR="ya.subr API:"

######## CHECK
# run only if new ya.subr is detected
if [ ! -d $YA_SUBR_TEST ] || ! grep -q "$YA_SUBR_STR" $YA_SUBR_TEST/ya.subr; then
   echo "New ya.subr not found"
   exit 1
fi
######## CHECK END

######## DEBUG-BEFORE
# Save some data, hope we won't need it =)
netstat -rn >/tmp/ya_subr_netstat.old.$$
ifconfig -a >/tmp/ya_subr_ifconfig.old.$$
######## DEBUG END

ya_action()
{
case $1 in
    start)
        /etc/rc.d/ya-netif start
        /etc/rc.d/ya-routing start
        /etc/rc.d/ya-fastbone start
    ;;
    stop)
        /etc/rc.d/ya-fastbone stop
        /etc/rc.d/ya-routing stop
        /etc/rc.d/ya-netif stop
    ;;
    *)
        if [ -z $1 ]; then
            echo "No or unknown argument provided to ya_action =("
            exit 1
        fi 
    ;; 
esac
}

ya_action stop

cp $YA_SUBR_TEST/ya.subr /etc/
cp $YA_SUBR_TEST/rc.d/ya-* /etc/rc.d/

ya_action start


ifconfig lo0 inet6 ::1 prefixlen 128
ifconfig lo0 inet 127.0.0.1

sleep 10
######## DEBUG-AFTER
netstat -rn >/tmp/ya_subr_netstat.new.$$
ifconfig -a >/tmp/ya_subr_ifconfig.new.$$
######## DEBUG END

exit 0
