#!/usr/bin/python

import ssl
import sys
import json
import urllib2
import socket
import subprocess
import os

if len(sys.argv) >= 2:
    GROUP=sys.argv[1]
elif os.path.exists('/etc/rtc-gencfg.group'):
    with open('/etc/rtc-gencfg.group', 'r') as f:
        GROUP=f.readline().strip()
else:
  sys.exit("Gencfg GROUP doesn't defined")
link = 'https://api.gencfg.yandex-team.ru/trunk/' \
       'searcherlookup/groups/{}/instances'.format(GROUP)

try:
    from ssl import create_default_context
except ImportError:
    c = json.loads(urllib2.urlopen(link).read())
else:
    ctx = ssl.create_default_context()
    ctx.check_hostname = False
    ctx.verify_mode = ssl.CERT_NONE
    c = json.loads(urllib2.urlopen(link, context=ctx).read())

print "GROUP: {}".format(GROUP)
for i in c['instances']:
    ihostname = i['hbf']['interfaces']['backbone']['hostname']
    print "\n"
    print "instance {}".format(ihostname)
    if i['hbf'].get('tunnels'):
        t = i['hbf']['tunnels'][0]
        tun_remote = t['remote_ipv6_address']
        tun_local = t['local_ipv6_address']
        ipv4_addr = t['ipv4_address']
        print "remote tun addr: {}".format(t['remote_ipv6_address'])
        print "local tun addr: {}".format(t['local_ipv6_address'])
        print "ipv4 address: {}".format(t['ipv4_address'])
        if ihostname.split('.')[0] == socket.gethostname().split('.')[0]:
            print "Found our instance, setting up..."
            subprocess.check_call(["ip", "-6", "tun", "add", "ip-ext-tun", "mode", "ipip6", "remote", tun_remote, "local", tun_local])
            subprocess.check_call(["ip", "-6", "link", "set", "ip-ext-tun", "up"])
            subprocess.check_call(["ip", "addr", "add", "dev", "ip-ext-tun", "{ipv4}/32".format(ipv4=ipv4_addr)])
            subprocess.check_call(["ip", "route", "add", "default", "dev", "ip-ext-tun"])
