"""
Experimental go-style context.
"""


class ICtx(object):
    def done(self):
        """
        :rtype: bool
        """
        raise NotImplementedError

    def error(self):
        """
        :rtype: basestring
        """
        raise NotImplementedError


class Ctx(ICtx):
    @classmethod
    def with_cancel(cls):
        ctx = cls()

        def cancel_func(err):
            ctx._err = err
            ctx._done = True

        return ctx, cancel_func

    def __init__(self):
        self._done = False
        self._err = ''

    def done(self):
        return self._done

    def error(self):
        return self._err
