
from yql.api.v1.client import YqlClient
from infra.rtc.rtc_billing.utils import get_hour_end
import nirvana.job_context as nv
import json
import os


LAST_CHECK_QUERY = '''
USE hahn;

pragma yt.InferSchema;
pragma SimpleColumns;
PRAGMA yson.DisableStrict;
pragma yt.Pool = 'runtimecloud';

SELECT
max(lb_timestamp), sku
FROM hahn.`home/runtimecloud/billing_logbroker_logs/logbroker_data`
GROUP BY sku
'''


if __name__ == '__main__':

    client = YqlClient(db='hahn')
    previous_hour_end = get_hour_end() - 3600
    metric_overtime = 0

    request = client.query(
        LAST_CHECK_QUERY,
        syntax_version=1
    )
    request.run()

    overdue_metrics = 0

    for table in request.get_results():
        table.fetch_full_data()

        for row in table.rows:
            if row[0] < previous_hour_end:
                overdue_metrics += 1

    metric = {
        "metrics": [
            {
                "labels": {"sensor": "quotas_overdue"},
                "value": overdue_metrics,
                "type": "IGAUGE"
            }
        ]
    }

    job_context = nv.context()
    outputs = job_context.get_outputs()
    filename = os.environ.get("OUTPUT_FILENAME")

    with open(outputs.get(filename), "w") as write_file:
        json.dump(metric, write_file)
