
import nirvana.job_context as nv
import json
import os
from collections import Counter, defaultdict


def transform_metric(metrics):

    metric_counter, solomon_metrics, abcs = Counter(), [], defaultdict(set)

    # Если процесс регенирирует после аварии то интересен только
    # последний timestamp
    last_timestamp = max([i["source_wt"] for i in metrics])

    for record in metrics:

        if record["source_wt"] != last_timestamp:
            continue

        metric_counter.update({record["schema"]: record["usage"]["quantity"]})
        abcs[record["schema"]].add(record["abc_id"])

    for schema, value in metric_counter.items():
        solomon_metrics.append(
            {
                "labels": {"sensor": schema},
                "value": value,
                "type": "IGAUGE"
            }
        )

    for schema, abc_set in abcs.items():
        solomon_metrics.append(
            {
                "labels": {"sensor": schema + "_abc_count"},
                "value": len(abc_set),
                "type": "IGAUGE"
            }
        )

    return {"metrics": solomon_metrics}


def transform_metric_per_service(metrics):
    yt_payload = []

    for record in metrics:

        yt_record = {
            "provider": record["schema"].split(".")[0],
            "lb_timestamp": record["source_wt"],
            "sku": record["schema"],
            "abc_id": record["abc_id"],
            "unit": record["usage"]["unit"],
            "quantity": record["usage"]["quantity"]
        }

        if record.get("labels", {}).get("geo"):
            yt_record["geo"] = record["labels"]["geo"]

        if record.get("labels", {}).get("segment"):
            yt_record["segment"] = record["labels"]["segment"]

        yt_payload.append(yt_record)

    return yt_payload


if __name__ == '__main__':
    job_context = nv.context()
    outputs = job_context.get_outputs()
    inputs = job_context.get_inputs()
    provider_data = json.load(open(inputs.get(os.environ.get("INPUT_FILENAME"))))
    transformed_data = transform_metric(provider_data)
    per_service_data = transform_metric_per_service(provider_data)

    filename = os.environ.get("OUTPUT_FILENAME")
    yt_payload_filename = os.environ.get("YT_PAYLOAD_FILENAME")
    with open(outputs.get(filename), "w") as write_file:
        json.dump(transformed_data, write_file)
    with open(outputs.get(yt_payload_filename), "w") as write_file:
        json.dump(per_service_data, write_file)
