# -*- coding: utf-8 -*-

import walle_api
import argparse
import json
import requests

J_API = "https://juggler-api.yandex-team.ru/v2"

def check_heartbeat(hosts_list, service_name, limit):
    session = requests.Session()
    session.headers["Content-Type"] = "application/json"
    hand = "/events/get_raw_events"
    j_filter = [{"host":h, "service":service_name} for h in hosts_list]
    resps = session.post('{}{}'.format(J_API, hand), data=json.dumps({"filters": j_filter}))
    if resps.ok:
        result = resps.json()
        for i in result["items"]:
            if i["heartbeat"] <= limit:
                print("{}: {}".format(i["host"], i["heartbeat"]))
    else:
        print(resps.text)

def main():
    """
    Shows duplicate hosts with same juggler-client-id. RUNTIMECLOUD-14053
    """
    parser = argparse.ArgumentParser(description=main.__doc__, add_help=True)
    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument("-p", dest="project", help="Filter hosts by wall-e projects")
    group.add_argument("-t", dest="tag", help="Filter hosts by wall-e tags")
    parser.add_argument("-s", dest="service", default="walle_host_certificate", help="Jugler service name")
    parser.add_argument("-l", dest="limit", default=200, help="Limit juggler heartbeat (sec)")
    args = parser.parse_args()
    client = walle_api.WalleClient()
    hosts_list =  []
    for host in client.iter_hosts(tags=args.tag, project=args.project):
        hosts_list.append(host["name"])
        if len(hosts_list) == 50:
            check_heartbeat(hosts_list, args.service, args.limit)
            hosts_list =  []
    else:
        check_heartbeat(hosts_list, args.service, args.limit)

if __name__ == "__main__":
    main()
