# coding: utf-8

import os
import logging

OAUTH_TOKEN = os.environ.get("OAUTH_TOKEN", "")


def read_token():
    global OAUTH_TOKEN
    if OAUTH_TOKEN:
        return
    try:
        with open(os.path.expanduser("~/.yp/token")) as stream:
            OAUTH_TOKEN = stream.read().strip()
    except Exception:
        logging.exception("Can't get token")


def get_oauth_token():
    return OAUTH_TOKEN
