# coding: utf-8

import requests

import walle_api


def main():
    client = walle_api.WalleClient()
    for host in client.iter_hosts(tags=["rtc"], state="assigned", fields=["name", "health", "project"]):
        try:
            oops_reply = requests.get("https://oops.yandex-team.ru/api/hosts/{}/attributes/walle_group".format(host["name"])).json()
            if oops_reply.get("group") is None:
                print("{} got {!r}".format(host["name"], oops_reply))
        except Exception as exc:
            print("{} failed with: {!r}".format(host["name"], exc))


if __name__ == "__main__":
    main()
