# coding: utf-8
import subprocess
import sys

# see https://github.yandex-team.ru/einstellung/eine-server-stages/blob/master/helpers/r:h-getpost#L105 for details

CODES_GIGABYTE_V3 = ["0x04", "0x2d", "0x9d"]
CODES_GIGABYTE_V2 = ["0x34", "0xcc"]
CODES_AIC = ["0x32", "0x73", "0x0"]


def get_concrete_post(host, commands):
    try:
        return subprocess.check_output(["yaipmi", "-H", host, "raw"] + commands).strip()
    except subprocess.CalledProcessError:
        return None


def get_post(host):
    result = get_concrete_post(host, CODES_GIGABYTE_V3)
    if result is not None:
        return ("gigabyte_v3", result)

    result = get_concrete_post(host, CODES_GIGABYTE_V2)
    if result is not None:
        return ("gigabyte_v2", result)

    result = get_concrete_post(host, CODES_AIC)
    if result is not None:
        return ("aic", result)

    raise Exception("unknown platform")


def decode_payload(platform, payload):
    if platform == "gigabyte_v3":
        return payload
    else:
        raise Exception("unknown platform")


if __name__ == "__main__":
    host = sys.argv[1]
    platform, payload = get_post(host)
    print host, decode_payload(platform, payload)
