package parser

import (
	"github.com/yuin/goldmark"
	"github.com/yuin/goldmark/ast"
	"github.com/yuin/goldmark/parser"
	"github.com/yuin/goldmark/text"
	"github.com/yuin/goldmark/util"
)

type wikiLinkParser struct {
}

var defaultWikiLinkParser = &wikiLinkParser{}

func NewWikiLinkParser() parser.InlineParser {
	return defaultWikiLinkParser
}

func (s *wikiLinkParser) Trigger() []byte {
	return []byte{'('}
}

func (s *wikiLinkParser) Parse(parent ast.Node, block text.Reader, pc parser.Context) ast.Node {
	line, segment := block.PeekLine()
	if len(line) < 4 {
		return nil
	}
	if line[1] != '(' {
		return nil
	}

	i := 0
	opened := 0
	stop := -1
	firstSpaceIndex := -1
	spaceIndex := -1
	for i < len(line) {
		c := line[i]
		if c == ')' {
			opened--
			if opened == 0 {
				stop = i
				break
			}
		} else if c == ' ' {
			if firstSpaceIndex < 0 {
				firstSpaceIndex = i
			}
			spaceIndex = i
		} else if c == '(' {
			opened++
		}
		i++
	}

	if stop < 0 || spaceIndex < 0 {
		return nil
	}

	link := ast.NewLink()
	link.AppendChild(link, ast.NewTextSegment(text.NewSegment(segment.Start+firstSpaceIndex+1, segment.Start+stop-1)))
	link.Destination = line[2:firstSpaceIndex]

	block.Advance(stop + 1)

	return link
}

type wikilink struct {
}

var WikiLink = &wikilink{}

func (e *wikilink) Extend(m goldmark.Markdown) {
	m.Parser().AddOptions(parser.WithInlineParsers(
		util.Prioritized(NewWikiLinkParser(), 250),
	))
}
