package main

import (
	"bytes"

	mr "a.yandex-team.ru/infra/rtc/sbin/wiki_dump/markdown"
	parser "a.yandex-team.ru/infra/rtc/sbin/wiki_dump/parser"

	"github.com/yuin/goldmark"
	"github.com/yuin/goldmark/extension"
	"github.com/yuin/goldmark/renderer"
	"github.com/yuin/goldmark/util"
)

type wikiTransformer struct {
	markdown goldmark.Markdown
}

func NewWikiTransformer() *wikiTransformer {
	return &wikiTransformer{
		markdown: goldmark.New(
			goldmark.WithExtensions(
				parser.WikiImage,
				parser.WikiLink,
				parser.WikiHeading,
				parser.WikiCodeSpan,
				parser.WikiFencedCodeBlock,
				extension.NewLinkify(
					extension.WithLinkifyAllowedProtocols([][]byte{
						[]byte("http:"),
						[]byte("https:"),
					}),
				),
			),
			goldmark.WithRenderer(
				renderer.NewRenderer(renderer.WithNodeRenderers(util.Prioritized(mr.NewRenderer(), 1000))),
			),
		),
	}
}

func (t *wikiTransformer) Transform(incoming []byte) ([]byte, error) {
	var buf bytes.Buffer
	err := t.markdown.Convert([]byte(incoming), &buf)
	if err != nil {
		return nil, err
	} else {
		return buf.Bytes(), nil
	}
}
