#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
from subprocess import Popen, PIPE
import argparse
import getpass
import datetime
import time
import json
import random
import string
import glob

#FIXME: запиххнуть все глобальные переменные и методы вокруг vmctl в класс

#FIXME: нужно запускать sandbox-таск и получать из него rbtorrent ресурса
# пока буду хардкодить или прокину в аргументы. Или мы перейдём на
# стандартный образ - пока не понятно.
RB_TORRENT = "rbtorrent:123b7ea816367b7b22d4c1112709d29bcf12a3ad"
VCPU = 2
VCPU_LIMIT = 2
VCPU_GUARANTEE = 2
CLUSTER = "SAS" #FIXME: тут будет отдельный (приватный?) кластер. Использовать ANY для теста не получится, т.к. deallocate требует явного указания региона (уточнить у frolstas@)
NETWORK_ID = "_SREAA_NETS_" #FIXME: тут будет выделенная сеть
NODE_SEGMENT = "default"
STORAGE_CLASS = "ssd"
VOLUME_SIZE = "30G"
RAM = "12G"
LOGINS = "noiseless sivanichkin ndolganov antivabo zomb-pretender"
GROUPS = "151957"
WHOAMI = getpass.getuser()
HOME_DIR = os.path.expanduser("~")
aactl_dir = "{}/.aactl".format(HOME_DIR)
vm_names_file_prefix = "vms"
vm_names_file = "{}/.aactl_vms".format(HOME_DIR)
CHALLENGES = "./challenges/"
LOGS = "./logs/"
TOP_SLS = os.path.join(CHALLENGES, "./top.sls")
DOMAIN = "sas.yp-c.yandex.net"
SSH_OPTIONS = "-o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o ConnectTimeout=10"
SCP = "scp {}".format(SSH_OPTIONS)
SSH = "ssh {}".format(SSH_OPTIONS)

if WHOAMI not in LOGINS:
    LOGINS = "{} {}".format(LOGINS, WHOAMI)


def pexit(msg):
    print msg
    sys.exit(1)

def gen_random_string(length=4):
    letters = string.ascii_lowercase
    return ''.join(random.choice(letters) for i in range(length))

def check_vmctl_or_ya_existance():
    _YA = "ya"
    _VMCTL = "vmctl"
    VMCTL = ""
    YA = ""

    for p in os.environ["PATH"].split(":"):
        VMCTL = os.path.join(p, _VMCTL)
        YA = os.path.join(p, _YA)
        if os.path.exists(VMCTL):
            return VMCTL
        if os.path.exists(YA):
            return "{} vmctl".format(YA)

    pexit("Install vmctl or ya to use aactl!")

# Создаём виртуальную машину. Через vmctl, т.к. у QYP нет sdk, а api нестабилен
def create_vm(vm_name):
    cmd = '{} create -y -i {} -t Linux -c {} --vcpu-limit {} --vcpu-guarantee {} --image-type RAW --cluster {} --network-id {} \
         --node-segment {} --volume-size {} --memory {} --logins {} --groups {} --storage {} \
         --pod-id {}'.format(
                        VMCTL,
                        RB_TORRENT,
                        VCPU,
                        VCPU_LIMIT,
                        VCPU_GUARANTEE,
                        CLUSTER,
                        NETWORK_ID,
                        NODE_SEGMENT,
                        VOLUME_SIZE,
                        RAM,
                        LOGINS,
                        GROUPS,
                        STORAGE_CLASS,
                        vm_name
                            )

    pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

    if pout != '' and pout != '\n':
        print "STDOUT={}".format(pout.rstrip('\n'))

    if err != '' and err != '\n':
        print "STDERR={}".format(err.rstrip('\n'))

# Создаём N виртуалок, возвращаем список с их короткими именами
def create_n_vms(num_vms):
    vms = []
    examination_id = gen_random_string()
    vm_file_path = os.path.join(aactl_dir, "{}_{}".format(vm_names_file_prefix, examination_id))
    for i in range(0, num_vms):
        # логин собеседующего не включается в имя виртуалки, т.к. максимальная длинна - 30 символов
        vm_name = "sre-aa-{}-{}-{}".format(datetime.date.today(), examination_id, i)
        print " => Creating {}.{}, https://qyp.yandex-team.ru/vm/{}/{}".format(vm_name, DOMAIN, CLUSTER.lower(), vm_name)
        #FIXME: проверять наличие файла и повторного использования
        with open(vm_file_path, 'a+') as f:
            f.write("{}\n".format(vm_name))
        create_vm(vm_name)
        vms.append(vm_name)

    return vms

def deallocate_vm(vm_name):
    cmd = '{} deallocate -y --cluster {} --pod-id {}'.format(VMCTL, CLUSTER, vm_name)

    pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

    if pout != '' and pout != '\n':
        print pout

    if err != '' and err != '\n':
        print err

def backup_logs(vm_name):
        vm_dns = vm_name + "." + DOMAIN
        log_path = os.path.join(LOGS, vm_name)
        if not os.path.exists(LOGS):
            os.mkdir(LOGS)
        os.mkdir(log_path)
        cmd = "{} root@{}:/place/vartmp/casts/*.cast {}".format(SCP, vm_dns, log_path)
        pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

def vm_exist(vm_name):
    vmctl_out = ''
    cmd = '{} status --cluster {} --pod-id {}'.format(
                                                    VMCTL,
                                                    CLUSTER,
                                                    vm_name
                                                     )

    pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

    try:
        vmctl_out = json.loads(pout)
    except:
        pexit("Failed to load JSON from vmctl status!")

    if 'msg' in vmctl_out:
        return False

    return True

def get_vm_status(vm_name):
    vmctl_out = ''
    cmd = '{} status --cluster {} --pod-id {}'.format(
                                                    VMCTL,
                                                    CLUSTER,
                                                    vm_name
                                                     )

    pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

    try:
        vmctl_out = json.loads(pout)
    except:
        return ''

    if 'msg' in vmctl_out:
        return ''

    return vmctl_out["state"]["type"]

# Ждём 130с (примерно время запуска виртуалки), далее в цикле с увеличивающимся таймаутом
# проверяем их статус, пока он не будет 'RUNNING' у всех
def wait_for_vms(vm_list):
    attempts = 10
    base_timeout = 130
    timeout = 10
    all_vms_not_ready = True

    print " => Wait until all VMs became ready"
    time.sleep(base_timeout)

    while all_vms_not_ready:
        if attempts == 0:
            pexit("FATAL: Could not check vm status after {} attempts!".format(attempts))

        for vm in vm_list:
            status = get_vm_status(vm)
            print "Attempts remained: {}, Current timeout: {}, vm: {}, status: {}".format(attempts, timeout, vm, status)
            if status != 'RUNNING':
                all_vms_not_ready = True
            else:
                all_vms_not_ready = False

        time.sleep(timeout)
        timeout = timeout + 5
        attempts = attempts - 1

#    time.sleep(100) #FIXME: magic

# ждём, пока виртуалки не будут доступны по ssh
    attempts = 40
    base_timeout = 10
    timeout = 5
    all_vms_not_ready = True
    print " => Wait until all VMs became available over ssh"
    time.sleep(base_timeout)

    while all_vms_not_ready:
        if attempts == 0:
            pexit("FATAL: Could not check vm availability after {} attempts!".format(attempts))

        for vm in vm_list:
            #FIXME
            vm_dns = vm + '.' + DOMAIN
            status = get_vm_status(vm)
            cmd = "{} root@{} 'echo OK'".format(SSH, vm_dns)
            pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()
            print "Attempts remained: {}, Current timeout: {}, vm: {}, err: {}".format(attempts, timeout, vm, err)
            if pout == 'OK':
                all_vms_not_ready = True
            else:
                all_vms_not_ready = False

        time.sleep(timeout)
        timeout = min(timeout + 5, 30)
        attempts = attempts - 1


def gen_top_sls(challenges):
    top = "base:\n"
    top += "  '*':\n"
    for challenge in challenges:
        top += "    - {}".format(challenge)

    with open(TOP_SLS, 'w') as f:
        f.write(top)

# пока притаскиваем все задания на все виртуалки. Сейчас она только одна, т.е. возможно
# только это и надо
def deploy_challenges(challenges, vms):
    print " => Deploy challenges"
    for vm in vms:
        vm_dns = vm + "." + DOMAIN
        cmd = "{} root@{} ' mkdir -p /srv/states ' ".format(SSH, vm_dns)
        pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()
        cmd = "{} {} root@{}:/srv/states/top.sls".format(SCP, TOP_SLS, vm_dns)
#        print cmd
        pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()
#        print ("out= {}".format(pout))
#        print ("err= {}".format(err))
        for challenge in challenges:
            challenge_sls = "{}.sls".format(challenge)
            cmd = "{} {} root@{}:/srv/states/{}".format(SCP, os.path.join(CHALLENGES, challenge_sls), vm_dns, challenge_sls)
#            print cmd
            pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()
#            print ("out= {}".format(pout))
#            print ("err= {}".format(err))

        cmd = "{} root@{} 'salt-call state.apply'".format(SSH, vm_dns)
        pout, err = Popen(cmd, shell=True, stdout=PIPE, stderr=PIPE).communicate()

def list_examinations():
    vms = glob.glob("{}/vms_*".format(aactl_dir))
    for vm in vms:
        with open(vm, 'r') as f:
            vm_names = f.read().rstrip('\n')
            print "{}:".format(os.path.basename(vm))
            for name in vm_names.split('\n'):
                print "    {} - ({}.{})".format(name, name, DOMAIN)


VMCTL = check_vmctl_or_ya_existance()

parser = argparse.ArgumentParser(description="Create and destroy VM's for AA")
subparsers = parser.add_subparsers(dest="subparser_name")
create_parser = subparsers.add_parser('create', help='Create virtual machines')
create_parser.add_argument('challenges', action="store", nargs='?',
                    help="Specify challenges")
create_parser = subparsers.add_parser('list', help='List created challenges and virtual machines')
deallocate_parser = subparsers.add_parser('deallocate', help='Deallocate virtual machines')
deallocate_parser.add_argument('--all', action="store_true", help='Deallocate all virtual machines')
deallocate_parser.add_argument('name', action="store", nargs='?',
                    help="Specify challenges")

args = parser.parse_args()

if args.subparser_name == 'create':
    if hasattr(args, 'challenges') and args.challenges:
        challenges = args.challenges.split(",")

        for challenge in challenges:
            path = os.path.join("./challenges/", challenge + ".sls")
            if not os.path.isfile(path):
                pexit("Challenge not found: {}!".format(challenge))

        vm_names = ''
        if not os.path.exists(aactl_dir):
            os.mkdir(aactl_dir)

        vms = create_n_vms(1)
        wait_for_vms(vms)
        gen_top_sls(challenges)
        deploy_challenges(challenges, vms)
        print " => Done"

    else:
        pexit("You must specify challenges!")

if args.subparser_name == 'list':
    if not os.path.exists(aactl_dir):
        pexit("No active challenges!")

    list_examinations()

#FIXME: обобщить код и натыкать проверок, текущий вариант - в лоб
if args.subparser_name == 'deallocate':
    if not os.path.exists(aactl_dir):
        pexit("No active challenges!")

    if args.all:
        vms = glob.glob("{}/vms_*".format(aactl_dir))
        for vm in vms:
            with open(vm, 'r') as f:
                vm_names = f.read().rstrip('\n')
                for name in vm_names.split('\n'):
                    print " => Backuping logs from vm {}".format(name)
                    backup_logs(name)
                    print " => Deallocating vm {}".format(name)
                    deallocate_vm(name)
                    os.remove(vm)

    if hasattr(args, 'name') and args.name:

        path = os.path.join(aactl_dir, args.name)
        if not os.path.exists(path):
            pexit("Specified challenge does not exist!")

        with open(path, 'r') as f:
            vm_names = f.read().rstrip('\n')
            for name in vm_names.split('\n'):
                print " => Backuping logs from vm {}".format(name)
                backup_logs(name)
                print " => Deallocating vm {}".format(name)
                deallocate_vm(name)
                os.remove(path)
