package main

import (
	"encoding/json"
	"io/ioutil"
	"os"
)

type appConfig struct {
	BufferSize  int64    `json:"buffer_size_in_pages"`
	Threads     int64    `json:"threads"`
	AccessLog   string   `json:"access_log"`
	DataSources []string `json:"data_sources"`
}

func readConfig(f string) (appConfig, error) {
	var config appConfig

	data, err := ioutil.ReadFile(f)
	if err != nil {
		return config, err
	}

	err = json.Unmarshal(data, &config)
	if err != nil {
		return config, err
	}

	return config, nil
}

func findConfig() string {
	var configFile string
	var foundConfig bool
	configsChain := []string{
		".broken_app.conf",
	}

	for _, configName := range configsChain {
		configFile = os.Getenv("HOME") + "/" + configName
		_, err := os.Stat(configFile)

		if os.IsNotExist(err) {
			continue
		}

		foundConfig = true
		break
	}

	if !foundConfig {
		defaultConfigFile := "/usr/local/var/run/.broken_app.default.huge_instance.conf"
		_, err := os.Stat(defaultConfigFile)
		if !os.IsNotExist(err) {
			return defaultConfigFile
		}
	}

	if !foundConfig {
		os.Exit(1)
	}

	return configFile
}

func loadConfig() appConfig {
	var config appConfig
	configFile := findConfig()

	config, err := readConfig(configFile)
	if err != nil {
		os.Exit(1)
	}

	return config
}
