package main

import (
	"fmt"
	"log"
	"os"
)

const PAGESIZE int64 = 4096

func main() {
	logger := log.New(os.Stderr, "", 0)

	config := loadConfig()
	// Print instance config info

	logger.Println("Starting new instance...")
	logger.Println(fmt.Sprintf("Config: BufferSize = %v", config.BufferSize*PAGESIZE))
	logger.Println(fmt.Sprintf("Config: Threads = %v", config.Threads))
	logger.Println(fmt.Sprintf("Config: Data sources = %v", config.DataSources))

	_ = make([]int64, 0, config.BufferSize*PAGESIZE)

	paw_reports := make([]chan bool, config.Threads)

	for i := int64(0); i < config.Threads; i++ {
		source := config.DataSources[i%int64(len(config.DataSources))]
		fmt.Printf("%s thread_id: %d\n", source, i)
		c := make(chan bool)
		go spiderPaw(source, i, c, config.AccessLog)
		paw_reports[i] = c
	}

	for i, c := range paw_reports {
		result := <-c
		fmt.Printf("goruting %d request result is %v\n", i, result)
	}

}
