package main

import (
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"os"
	"time"
)

func spiderPaw(source string, id int64, done chan bool, access_log_file string) {

	f, err := os.Create(access_log_file)
	if err != nil {
		panic(err)
	}
	accessLog := log.New(f, "", log.LstdFlags)

	for i := 0; i < 1000; i++ {
		time.Sleep(1 * time.Second)
		url := fmt.Sprintf("http://%s/%d/%d.txt", source, id, i)

		rStart := time.Now()
		resp, err := http.Get(url)

		requestTime := float32(time.Since(rStart) / time.Millisecond)
		if err != nil {
			// FIXME: Do something here

			accessLogMessage := fmt.Sprintf("thread:%d request_id:%d %s %d %5.1f ms %s", id, i, url, -1, requestTime, err)
			accessLog.Printf("%s\n", accessLogMessage)
		} else {
			body, err := ioutil.ReadAll(resp.Body)
			if err != nil {
				fmt.Printf("Can't read resp Body")
				// FIXME: Do something here
			}
			if requestTime > 100 {
				fmt.Printf("Found long request_id %d (%5.1f ms), see logs for details \n", i, requestTime)
			}

			accessLogMessage := fmt.Sprintf("thread:%d request_id:%d %s %d %5.1f ms %d", id, i, url, resp.StatusCode, requestTime, len(body))
			accessLog.Printf("%s\n", accessLogMessage)
		}
	}
	done <- true
}
