# -*- coding: utf-8 -*-

from dateutil import parser as dateparser

import logging
import requests


# logging
log = logging.getLogger()

BASE_CALENDAR_URL = "https://api.calendar.yandex-team.ru/intapi"


def get_num_workdays(from_date, to_date):
    """
    :param from_date: date string within format YYYY-mm-dd
    :param to_date: date string within format YYYY-mm-dd
    :return: number working days between to dates
    """
    num_days = (dateparser.parse(to_date) - dateparser.parse(from_date)).days
    method = "get-holidays"
    request_uri = "{}/{}?from={}&to={}&for=rus".format(BASE_CALENDAR_URL, method, from_date, to_date)
    log.debug(request_uri)
    result = requests.get(request_uri).json()
    log.debug(result)
    num_holidays = len([x for x in result['holidays'] if x['type'] != "weekday"])
    return num_days - num_holidays
