# -*- coding: utf-8 -*-

import requests
import logging
import six
import sys
from collections import defaultdict
from time import time


# logging
log = logging.getLogger()

# get python version
py = sys.version_info.major

class SolomonClient:
    __url = "https://solomon.yandex-team.ru/api/v2/projects/yt/sensors/data"
    __headers = {"Content-Type": "application/json;charset=UTF-8"}

    def __init__(self, oauth_token):
        self.__headers["Authorization"] = 'OAuth {}'.format(oauth_token)
        self.__ts = int(time()*1000)

    def get_a100_reserve_size(self):
        tree_name = "gpu_tesla_a100"
        return self.__get_data(tree_name)
    
    def get_a100_80g_reserve_size(self):
        tree_name = "gpu_tesla_a100_80g"
        return self.__get_data(tree_name)
    
    def __get_data(self, tree_name):
        data_raw = '{"program":"{project=\\"yt\\",service=\\"scheduler\\",sensor=\\"yt.scheduler.undistributed_resources.gpu\\",cluster=\\"hahn\\",tree=\\"' + tree_name + '\\"}",' + \
             '"from": ' + str(self.__ts - 10*60*1000) + ',' + \
            '"to": ' + str(self.__ts) + ',"downsampling": {"aggregation":"AVG","maxPoints":"10"}}'
        resp = requests.request(method='POST', url=self.__url, headers=self.__headers, data=data_raw)
        return int(resp.json().get('vector', [{}])[0].get('timeseries', {}).get('values', [-1])[-1])
