# -*- coding: utf-8 -*-

import requests


BASE_STAFF_V3 = "https://staff-api.yandex-team.ru/v3/"


def get_duty_telegram(login, token):
    headers = {'Authorization': 'OAuth {}'.format(token)}
    accounts = requests.get('{}persons?login={}&_fields=accounts'.format(BASE_STAFF_V3, login), headers=headers).json()
    if isinstance(accounts.get('result'), list):
        return [acc['value'] for acc in accounts['result'][0]['accounts'] if acc['type'] == 'telegram'][0]
