# -*- coding: utf-8 -*-

import requests

BASE_URL = "https://api.telegram.org/bot"


class telegram_simple:
    # simple telegram class

    def __init__(self, token, chatid):
        self.chatid = chatid
        self.tokenized = "{}{}".format(BASE_URL, token)

    def getUpdates(self):
        return requests.post("{}/getUpdates".format(self.tokenized))

    def sendMessage(self, message):
        requests.post("{}/sendMessage".format(self.tokenized), headers={'Content-Type': 'application/json'}, params={
            'chat_id': self.chatid,
            'text': message,
            'parse_mode': 'HTML',
        })
