# -*- coding: utf-8 -*-

from walle_api.client import WalleClient
from walle_api.constants import version as sdk_version, PRODUCTION_URL

DEFAUlT_LIMIT = 500

class WalleAbstract:
    """
    abstract wall-e client class
    """
    def __init__(self, token):
        self.walle_client = WalleClient(name="Sre.Bot", url=PRODUCTION_URL, access_token=token)

    def list_dead_rtc(self, limit=DEFAUlT_LIMIT):
        options = dict(tags='rtc', status='dead', fields=['name', 'inv', 'ticket', 'platform' , 'config'])
        return len([_ for _ in self.walle_client.iter_hosts(limit=limit, **options)])

    def list_2ndtime_rtc(self, limit=DEFAUlT_LIMIT):
        options = dict(tags='rtc', status='report-2nd-time-node', fields=['name', 'inv', 'ticket', 'platform' , 'config'])
        return len([_ for _ in self.walle_client.iter_hosts(limit=limit, **options)])

    def list_dead_gpu_rtc(self, limit=DEFAUlT_LIMIT):
        options = dict(tags='rtc.gpu_nvidia', status='dead', fields=['name', 'inv', 'ticket', 'platform' , 'config'])
        return len([_ for _ in self.walle_client.iter_hosts(limit=limit, **options)])
