#!/usr/bin/env bash

set -e

buildtmp=$(mktemp -d)
pushd $buildtmp

mkdir -p man/bcc
mkdir -p man/bpf
mkdir -p man/iproute2
mkdir -p doc/bcc
mkdir -p doc/bpf
mkdir src

cp -r $1/infra/rtc/sretools/tools tools/
cp -r $1/infra/rtc/sretools/doc ./
cp -r $1/infra/rtc/sretools/lib ./
cp $1/infra/rtc/sretools/sretool ./

# vendor bcctools
tar -xvf $2/infra/rtc/sretools/vendor/bcc/build/bcctools.tar.gz -C src >/dev/null || exit 1
mv src/include ./
cp -r src/lib/* ./lib/
for i in $(find src/share/bcc/tools/doc/ -type f -name *_example.txt); do n=$(basename $i _example.txt); mv $i doc/bcc/$n.txt; done
find src/share/bcc/tools/ -maxdepth 1 -type f -exec mv {} tools/bcc/ \; > /dev/null
for i in $(find src/share/bcc/man/man8/ -type f -name *.gz); do n=$(basename $i .8.gz); mv $i man/bcc/$n.gz; done
rm -rf src/*

# vendor bpftrace
tar -xvf $2/infra/rtc/sretools/vendor/bpftrace/build/bpftrace.tar.gz -C src >/dev/null || exit 1
mv src/src/bpftrace tools/
find src/tools/ -type f -name *.bt -exec mv {} tools/bpf/ \; > /dev/null
for i in $(find src/tools/ -type f -name *_example.txt); do n=$(basename $i _example.txt); mv $i doc/bpf/$n.bt.txt; done
for i in $(find src/man/man8/ -type f -name *.gz); do n=$(basename $i .8.gz); mv $i man/bpf/$n.bt.gz; done
mv src/docs/reference_guide.md doc/bpftrace.txt
rm -rf src/*

# vendor iproute2
tar -xvf $2/infra/rtc/sretools/vendor/iproute2/build/iproute2.tar.gz -C src || exit 1
mkdir tools/iproute2
mv src/misc/ss tools/iproute2/ss
mv src/ip/ip tools/iproute2/ip
mv src/tc/tc tools/iproute2/tc
for i in $(find  src/man/man8/ -type f -name *.8); do gzip -9 $i;  n=$(basename $i .8);  mv $i.gz man/iproute2/$n.gz; done
rm -rf src/*

# vendor mlc
gunzip -c $2/infra/rtc/sretools/vendor/mlc/build/mlc.tar.gz | tar -zxvf - -C src >/dev/null || exit 1
mv src/Linux/mlc tools/
rm -rf src/*

# vendor msr
tar -xzvf $2/infra/rtc/sretools/vendor/msr/build/msr.tar.gz -C src >/dev/null || exit 1
mv src/* tools/
rm -rf src/*

# tar
rm -rf src
popd
tar -czvf $3 -C $buildtmp .
rm -rf $buildtmp
