#!/usr/bin/python

import os
import subprocess

CGRP_PRFX_PATH = "/sys/fs/cgroup/"
CGRP_UN_PATH = CGRP_PRFX_PATH + "unified"
CGRP_CPU_PATH = CGRP_PRFX_PATH + "cpu"
CGRP_PROCS_NAME = "cgroup.procs"

def cgrp_path_to_pidns(c):
    full_path = os.path.join(CGRP_UN_PATH, CGRP_PRFX_PATH, "porto", c)
    return os.stat(full_path).st_ino

def cgrp_path_to_netns(c):
    procs_path = os.path.join(CGRP_UN_PATH, "porto", c, CGRP_PROCS_NAME)
    with open(procs_path) as p:
        for pid in p.readlines():
            statinfo = os.stat("/proc/"+pid.strip("\n")+"/ns/net")
            return statinfo.st_ino

def get_ifindex(s):
    ifindex_path = os.path.join("/sys/class/net/" + s + "/ifindex")
    with open(ifindex_path) as p:
        return int(p.readlines()[0])

def subprocess_run(sudo, args, **kwargs):
    sudo_args = []
    if sudo:
        sudo_args = ['sudo', '-E']
    return subprocess.run(sudo_args + args, **kwargs)

def subprocess_call(sudo, args, **kwargs):
    sudo_args = []
    if sudo:
        sudo_args = ['sudo', '-E']
    return subprocess.call(sudo_args + args, **kwargs)

def subprocess_check_output(sudo, args, **kwargs):
    sudo_args = []
    if sudo:
        sudo_args = ['sudo', '-E']
    return subprocess.check_output(sudo_args + args, **kwargs)
