IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:rtc-sysdev)

SET(IPROUTE2_RESOURCE 2300972746)
SET(IPROUTE2_GIT_TAG 5.13.0)
SET(IPROUTE2_SRC iproute2-${IPROUTE2_GIT_TAG}.tar.gz)

SET(OUT iproute2.tar.gz)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)
SET(VMEXEC_DEF_ROOTFS infra/environments/qavm-xenial/release/vm-image)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${IPROUTE2_RESOURCE}
    OUT ${IPROUTE2_SRC}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} --vcpu 8 --mem 8G -I ${VMEXEC_DEF_ROOTFS}/rootfs.img --
                   build.py build --install-deps ${IPROUTE2_SRC} ${OUT}
    CWD ${BINDIR}
    IN build.py
       ${IPROUTE2_SRC}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img
    OUT_NOAUTO ${OUT}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
