#!/usr/bin/env bash
# -*- coding: utf-8 -*-
TTL="inf"
BCCTOOLS_VER="v0.19.0"
BPFTRACE_VER="v0.11.4"
IPROUTE2_VER="5.13.0"
MLC_VER="v3.9a"
MSR_VER="1.2"

[ $1 == bcctools ] && [ ! -f bcctools-src.tar.gz ] && wget https://github.com/iovisor/bcc/releases/download/$BCCTOOLS_VER/bcc-src-with-submodule.tar.gz -O bcctools-src.tar.gz && \
ya upload bcctools-src.tar.gz --ttl=$TTL -d bcctools-$BCCTOOLS_VER.tar.gz --owner RTC_INFRA --sandbox

[ $1 == bpftrace ] && [ ! -f bpftrace-src.tar.gz ] && wget https://github.com/iovisor/bpftrace/archive/refs/tags/$BPFTRACE_VER.tar.gz -O bpftrace-src.tar.gz && \
ya upload bpftrace-src.tar.gz --ttl=$TTL -d bpftrace-$BPFTRACE_VER.tar.gz --owner RTC_INFRA --sandbox

[ $1 == iproute2 ] && [ ! -f iproute2-src.tar.gz ] && wget https://git.kernel.org/pub/scm/network/iproute2/iproute2.git/snapshot/iproute2-$IPROUTE2_VER.tar.gz -O iproute2-src.tar.gz && \
ya upload iproute2-src.tar.gz --ttl=$TTL -d iproute2-$IPROUTE2_VER.tar.gz --owner RTC_INFRA --sandbox

[ $1 == mlc ] && [ ! -f mlc-src.tar.gz ] && wget https://software.intel.com/content/dam/develop/external/us/en/documents/mlc_$MLC_VER.tgz -O mlc-src.tar.gz && \
ya upload mlc-src.tar.gz --ttl=$TTL -d mlc-$MLC_VER.tar.gz --owner RTC_INFRA --sandbox

[ $1 == msr ] && [ ! -f msr-tools.tar.gz ] && wget https://git.kernel.org/pub/scm/utils/cpu/msr-tools/msr-tools.git/snapshot/msr-tools-${MSR_VER}.tar.gz  -O msr-src.tar.gz && \
ya upload msr-src.tar.gz --ttl=$TTL -d msr-${MSR_VER}.tar.gz --owner RTC_INFRA --sandbox

#wget https://github.com/intel/numatop/archive/refs/tags/v2.1.tar.gz -O numatop.tar.gz
