# coding: utf-8

import os
import gzip
import io
import library.python.resource as rs
import click
import msgpack


def get_host_spec(hostname):
    unpacker = msgpack.Unpacker(gzip.GzipFile(fileobj=io.BytesIO(rs.find('/topology'))))
    for row in unpacker:
        if row["fqdn"] == hostname:
            return row
    return None


@click.command(context_settings=dict(
    ignore_unknown_options=True,
    allow_extra_args=True
))
@click.argument('hostname')
@click.pass_context
def main(ctx, hostname):
    host_spec = get_host_spec(hostname)
    if host_spec is None:
        raise click.ClickException("No host {!r} exists".format(hostname))

    ipv6addr = host_spec.get("ipv6addr")
    if ipv6addr is None:
        raise click.ClickException("Host {!r} hasn't ipv6 address".format(hostname))

    os.execlp("ssh", *["ssh", ipv6addr] + ctx.args)


if __name__ == "__main__":
    main()
