# coding: utf-8

import copy

LABEL_PREFIX = "rtc."
MARKETTAG_PREFIX = "market."


class Project(object):

    def __init__(self, id, name, tags, automation_plot_id=None, automation_limits=None, bot_project_id=None, certificate_deploy=None, cms_settings=None,
                 default_host_restrictions=None, deploy_config=None,
                 deploy_network=None, deploy_tags=None, dns_domain=None, extra_vlans=None, hbf_project_id=None, ip_method=None, native_vlan=None,
                 notifications=None, owned_vlans=None, owners=None, profile=None, profile_tags=None, provisioner=None, reports=None, vlan_scheme=None,
                 deploy_config_policy=None, reboot_via_ssh=None, dns_automation=None, healing_automation=None, roles=None):
        self.id = id
        self.name = name
        self.tags = tags
        self.automation_plot_id = automation_plot_id
        self.automation_limits = automation_limits
        self.bot_project_id = bot_project_id
        self.certificate_deploy = certificate_deploy
        if isinstance(cms_settings, list):
            self.cms_settings = cms_settings[0]
        else:
            self.cms_settings = cms_settings
        self.default_host_restrictions = default_host_restrictions
        self.deploy_config = deploy_config
        self.deploy_config_policy = deploy_config_policy
        self.deploy_network = deploy_network
        self.deploy_tags = deploy_tags
        self.dns_domain = dns_domain
        self.extra_vlans = extra_vlans
        self.hbf_project_id = hbf_project_id
        self.ip_method = ip_method
        self.native_vlan = native_vlan
        self.notifications = notifications
        self.owned_vlans = owned_vlans
        self.owners = owners
        self.profile = profile
        self.profile_tags = profile_tags
        self.provisioner = provisioner
        self.reports = reports
        self.vlan_scheme = vlan_scheme
        self.reboot_via_ssh = reboot_via_ssh
        self.dns_automation = dns_automation
        self.healing_automation = healing_automation
        self.roles = roles

    def cleanup(self):
        if self.dns_automation:
            self.dns_automation.pop("credit", None)
            self.dns_automation.pop("credit_end_time", None)
            self.dns_automation.pop("status_message", None)
        if self.healing_automation:
            self.healing_automation.pop("credit", None)
            self.healing_automation.pop("credit_end_time", None)
            self.healing_automation.pop("status_message", None)

    @property
    def labels(self):
        labels = {}
        for tag in self.tags:
            if tag.startswith(LABEL_PREFIX):
                key, _, value = tag[len(LABEL_PREFIX):].partition("-")
                assert key not in labels, "tag {} override another one in project {}".format(tag, self.id)
                labels[key] = value
        return labels

    @property
    def cleaned_tags(self):
        return [tag for tag in self.tags if not tag.startswith(LABEL_PREFIX) and not tag.startswith(MARKETTAG_PREFIX)]

    def to_dict(self):
        return {k: copy.deepcopy(v) for k, v in vars(self).iteritems() if v is not None}

    def __repr__(self):
        return "<Project {}>".format(self.id)
