# coding: utf-8
from __future__ import unicode_literals

# https://clubs.at.yandex-team.ru/infra-cloud-dev/653

KNOWN_TAGS = {
    "iss",
    "market",
    "production",
    "qloud",
    "qloud-external",
    "qloud-prestable",
    "report",
    "report_parallel",
    "rtc",
    "rtc_network",
    "rtc-enclave",
    "runtime",
    "search",
    "skynet_installed",
    "special_reboot",
    "wall-e.tor_link_disabled",
    "yabs",
    "yasm_monitored",
    "yasm_qloud_monitored",
    "yp",
    "yp_dev",
    "yp_iss",
    "yp_master_prestable",
    "yp_master_testing",
    "yp_masters",
    "yt",
    "testing",
    "tentacles_monitored",
}

KNOWN_LABEL_KEYS = {
    "automation",
    "gencfg",
    "gpu",
    "reboot_segment",
    "scheduler",
    "stage",
    "ypmaster",
    "yt_cluster",
    "isscacher",
    "cohabitation",
    "infiniband",
    "yt",
    "reserve",
}

RTC_TAG = "rtc"
RTC_ENCLAVE_TAG = "rtc-enclave"
RUNTIME_TAG = "runtime"
QLOUD_TAG = "qloud"
YABS_TAG = "yabs"
YT_TAG = "yt"
YP_DEV_TAG = "yp_dev"
YP_TAG = "yp"
YP_ISS_TAG = "yp_iss"
YP_MASTER_TESTING_TAG = "yp_master_testing"
YP_MASTER_PRESTABLE_TAG = "yp_master_prestable"
YP_MASTERS_TAG = "yp_masters"
MARKET_TAG = "market"
SKYNET_INSTALLED_TAG = "skynet_installed"
YASM_MONITORED_TAG = "yasm_monitored"
YASM_QLOUD_MONITORED_TAG = "yasm_qloud_monitored"
SPECIAL_REBOOT_TAG = "special_reboot"

DOOR_TO_RTC_GROUP = '@svc_doortortc'
RTCSRE_ABC_ADM_GROUP = '@svc_srertc_administration'
RTCSRE_ABC_DEVOPS_GROUP = '@svc_srertc_devops'
YT_ABC_DEV_GROUP = '@svc_yt_development'
RTCSUPPORT_GROUP = '@svc_rtcsupport'
LOGBROKER_ABC_DEVOPS_GROUP = '@svc_logbroker_devops'
SOLOMON_ABC_DEVOPS_GROUP = '@svc_solomon_devops'
DUTYSEARCH_ABC_DEVOPS_GROUP = '@svc_dutysearch_devops'
YA_AGENT_ABC_DEVOPS_GROUP = '@svc_ya_agent_devops'
ROBOT_WALLE = "robot-walle"

RTC_BAD_OWNERS = (
    '@yandex_mnt_sa_runtime_cross',
    '@yandex_mnt_sa_runtime_cross_9738',
    'affe',
    'alexsmirnov',
    'basic',
    'bgleb',
    'dkhrutsky'
    'flagist',
    'intr13',
    'kozhapenko',
    'mixas',
    'n-malakhov',
    'ndolganov',
    'noiseless',
    'nulltime',
    'qwizzy',
    'reddog',
    'sivanichkin',
    'squirrel',
    'terry',
    'xgen',
    'x0leg',
    'slonnn',
    'talion',
    'vminkov',
)

ALLOWED_RECEPIENTS = (
    "search-maintenance@yandex-team.ru",
    "wall-e-search-notifications@yandex-team.ru",
    "yp-monitoring@yandex-team.ru",
    "yt-maintenance@yandex-team.ru",
    "yt-admin@yandex-team.ru",
    "cs-admin-hw@yandex-team.ru",
    "qloud-walle@yandex-team.ru",
    "verytable@yandex-team.ru",
)

assert RTC_TAG in KNOWN_TAGS
assert RTC_ENCLAVE_TAG in KNOWN_TAGS
assert RUNTIME_TAG in KNOWN_TAGS
assert QLOUD_TAG in KNOWN_TAGS
assert YABS_TAG in KNOWN_TAGS
assert YT_TAG in KNOWN_TAGS
assert YP_TAG in KNOWN_TAGS
assert YP_ISS_TAG in KNOWN_TAGS
assert YP_MASTER_TESTING_TAG in KNOWN_TAGS
assert YP_MASTER_PRESTABLE_TAG in KNOWN_TAGS
assert YP_MASTERS_TAG in KNOWN_TAGS
assert MARKET_TAG in KNOWN_TAGS
assert SKYNET_INSTALLED_TAG in KNOWN_TAGS
assert YASM_MONITORED_TAG in KNOWN_TAGS
assert YASM_QLOUD_MONITORED_TAG in KNOWN_TAGS
assert YP_DEV_TAG in KNOWN_TAGS

PROJECT_TAG_SET = {
    RUNTIME_TAG,
    QLOUD_TAG,
    YT_TAG,
    YP_ISS_TAG
}
