# coding: utf-8


class CoverageUnit(object):

    def __init__(self):
        self._conditions = []

    def add(self, condition):
        self._conditions.append(condition)

    def match(self, project):
        return any(c.match(project) for c in self._conditions)

    def check(self, all_projects):
        non_covered_projects = [p for p in all_projects if not self.match(p)]
        assert not non_covered_projects, "projects not covered: {}".format(
            ", ".join(p.id for p in non_covered_projects)
        )


def create_coverage():
    return CoverageUnit()
