# coding: utf-8

import json

import requests


class SetupClient(object):

    def __init__(self, token):
        self.token = token

    def _fetch(self, method, args, kwargs):
        reply = requests.post(
            "https://setup.yandex-team.ru/api",
            headers={"Authorization": "OAuth {}".format(self.token)},
            data=json.dumps({"method": method, "args": args, "kwargs": kwargs})
        )
        reply.raise_for_status()
        return reply.json()

    def get_config(self, name):
        result = self._fetch("config_get", [], {"name": name})
        return result["result"]["config"]
