# coding: utf-8


class ProjectTransformer(object):
    """base transform project class"""

    def __init__(self, project):
        """:param project: project object"""
        self._touched = False
        self._project = project

    def _touch(self):
        """set changed state"""
        self._touched = True

    def is_touched(self):
        """:return changes state"""
        return self._touched

    def remove_tag(self, tag):
        if tag in self._project.tags:
            self._project.tags.remove(tag)
            self._touch()

    def append_tag(self, tag):
        if tag not in self._project.tags:
            self._project.tags.append(tag)
            self._touch()

    def remove_multiple_tags(self, tags):
        for tag in tags:
            self.remove_tag(tag)

    def remove_multiple_tags_by_predicate(self, predicate):
        """
        :param predicate: simple filter or suggest function
        :return: changes state
        """
        to_remove = []
        for tag in self._project.tags:
            if predicate(tag):
                to_remove.append(tag)
        self.remove_multiple_tags(to_remove)
