import sys
import pyuwsgi

from infra.rtc_sla_tentacles.backend.lib.api.api_class import Api
from infra.rtc_sla_tentacles.backend.lib.config.interface import ConfigInterface
from infra.rtc_sla_tentacles.backend.lib.util import SentrySender


def app():
    api = Api(cfg)
    return api.make_api_app(log_file=True, log_stdout=False, it_is_uwsgi=True)


def run_debug():
    api = Api(cfg)
    debug_app = api.make_api_app(log_file=True, log_stdout=True, it_is_uwsgi=False)
    debug_app.run(host="::", port=8080, debug=False, load_dotenv=False)


if __name__ == "__main__":
    cfg = ConfigInterface(sentry_sender=SentrySender(manual_init=True))
    api_config = cfg.get_api_config()
    args = [
        "--http", "[::]:" + str(api_config['port']),
        "--module", "__main__:app()",
        "--pyargv", " ".join(sys.argv[1:]),
        "-p", str(api_config['processes']),
        "--threads", str(api_config["threads"]),
        "--master",
        "--listen", str(api_config['listen_queue']),
        '--logto', api_config['logfile'],
    ]
    if api_config['log_maxsize']:
        args.append([
            '--log-maxsize', str(api_config['log_maxsize']),
            "--log-reopen",
        ])
    pyuwsgi.run(args)
