import os
import sys
import logging
import threading

from infra.rtc_sla_tentacles.backend.lib.harvesters.ticker import Ticker
from infra.rtc_sla_tentacles.backend.lib.config.interface import ConfigInterface
from infra.rtc_sla_tentacles.backend.lib.debug.reverse import ReplServer, repl_client
from infra.rtc_sla_tentacles.backend.lib.funccall_stats_server import server as stat_server
from infra.rtc_sla_tentacles.backend.lib.harvesters.manager import HarvestersManager
from infra.rtc_sla_tentacles.backend.lib.harvesters_snapshots.manager import HarvesterSnapshotManager
from infra.rtc_sla_tentacles.backend.lib.util import SentrySender
from infra.rtc_sla_tentacles.backend.lib.mongo.client import MongoClient

logger = logging.getLogger("common.binary.worker")


if __name__ == "__main__":
    # FIXME cli args are parsed by raw_config_storage now, it's wrong
    # and we have to check for alternative mode right here and without
    # argparse
    if len(sys.argv) > 2 and sys.argv[1] == '--attach':
        raise SystemExit(repl_client(sys.argv[2]))

    ci = ConfigInterface(sentry_sender=SentrySender())

    worker_config = ci.get_worker_config()
    debug_dir = worker_config['debug']['sock_path']
    repl = None
    if debug_dir:
        sock_path = os.path.join(debug_dir, f"repl.{os.getpid()}.sock")
        repl = ReplServer(sock_path=sock_path)
        repl.start()

    try:
        mongo_client = MongoClient(ci)
        snapshot_manager = HarvesterSnapshotManager(mongo_client)
        manager = HarvestersManager(ci, snapshot_manager)
        stat_server.init_harvester_unistat(g.harvester_type for g in manager.get_harvester_groups())
        stats = stat_server.FunccallStatsServer(
            "worker",
            worker_config['http']['port'],
            thread_count=Ticker.DEFAULT_WORKER_COUNT,
        )
        ticker = Ticker(manager, ci, mongo_client, stats)

        flask_thread = threading.Thread(target=stats.run_flask)
        flask_thread.daemon = True
        flask_thread.start()

        logger.debug("Running main worker loop")
        ticker.loop()
    finally:
        if repl is not None:
            repl.stop_repl()
